/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums;

import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethod;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@Description(value="A marker which contains mapping between JEnumField and constant use into case statement.")
@ValidOn(value={JMethod.class})
public final class EnumMappingMarker
implements Marker {
    @Nonnull
    private final Map<JFieldId, Integer> enumFieldToSwitchValue = new HashMap<JFieldId, Integer>();

    public void addMapping(@Nonnull JFieldId enumField, int value) {
        this.enumFieldToSwitchValue.put(enumField, value);
    }

    @Nonnull
    public Map<JFieldId, Integer> getMapping() {
        return this.enumFieldToSwitchValue;
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }
}

