/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.Jack;
import com.android.jack.google.common.collect.Lists;
import com.android.jack.google.common.collect.Maps;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.load.NopClassOrInterfaceLoader;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.transformations.enums.opt.EnumFieldMarker;
import com.android.jack.transformations.enums.opt.OptimizationUtil;
import com.android.jack.transformations.enums.opt.OptimizedSwitchEnumSupport;
import com.android.jack.transformations.enums.opt.SwitchEnumOptStrategy;
import com.android.jack.transformations.enums.opt.SwitchEnumUsageMarker;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class SyntheticClassManager {
    @Nonnull
    public static final String SyntheticSwitchmapClassNamePrefix = "SyntheticSwitchmapClass-";
    @Nonnull
    public static final String PublicSyntheticSwitchmapClassPkgName = "com/android/jack/enums/synthetic";
    @Nonnull
    public static final StatisticId<Counter> SYNTHETIC_SWITCHMAP_CLASS = new StatisticId<Counter>("jack.optimization.enum.switch.synthetic.class.increase", "Total number of synthetic class created", CounterImpl.class, Counter.class);
    @Nonnull
    private final SwitchEnumOptStrategy optimizationStrategy = ThreadConfig.get(OptimizedSwitchEnumSupport.OPTIMIZED_ENUM_SWITCH);
    @Nonnull
    private final Map<JPackage, JDefinedClass> syntheticClassMap = Maps.newHashMap();
    @Nonnull
    private final Tracer statisticTracer = TracerFactory.getTracer();
    @Nonnull
    private final JSession session = Jack.getSession();
    @Nonnull
    private final OptimizationUtil supportUtil;
    @Nonnull
    private final Map<String, JDefinedClass> deletedLibSyntheticClasses = Maps.newHashMap();

    public SyntheticClassManager(@Nonnull OptimizationUtil supportUtil) {
        this.supportUtil = supportUtil;
    }

    @CheckForNull
    public JDefinedClass getOrCreateSyntheticClass(@Nonnull JDefinedEnum enumType, boolean createIfNotExist) {
        String syntheticClassFullName2;
        JPackage syntheticClassPackage = enumType.isPublic() ? this.session.getLookup().getOrCreatePackage(PublicSyntheticSwitchmapClassPkgName) : enumType.getEnclosingPackage();
        JDefinedClass syntheticClass = this.syntheticClassMap.get(syntheticClassPackage);
        if (syntheticClass == null) {
            syntheticClass = this.getSyntheticClassUnderPackage(syntheticClassPackage);
        }
        assert (syntheticClass != null || createIfNotExist);
        SwitchEnumUsageMarker enumUsageMarker = syntheticClassPackage.getMarker(SwitchEnumUsageMarker.class);
        boolean isOptWorth = false;
        HashSet<JDefinedEnum> usedEnumsType = Sets.newHashSet();
        if (this.optimizationStrategy == SwitchEnumOptStrategy.FEEDBACK) {
            assert (enumUsageMarker != null);
            usedEnumsType.addAll(enumUsageMarker.getUsedEnumsType());
        } else {
            usedEnumsType.add(enumType);
        }
        if (syntheticClass != null) {
            isOptWorth = usedEnumsType.addAll(this.getPredefinedEnumsType(syntheticClass));
        }
        this.initEnumFieldMarkers(usedEnumsType);
        if (!isOptWorth) {
            isOptWorth = this.optimizationStrategy == SwitchEnumOptStrategy.ALWAYS ? true : this.isOptimizationWorthwhile(enumUsageMarker.getUses(), usedEnumsType);
        }
        if (!isOptWorth) {
            return null;
        }
        String uuid = this.getSyntheticClassUUID(usedEnumsType);
        String syntheticClassName = SyntheticSwitchmapClassNamePrefix + uuid;
        try {
            syntheticClassFullName2 = "L" + BinaryQualifiedNameFormatter.getFormatter().getName(syntheticClassPackage) + "/" + syntheticClassName + ";";
            JDefinedClass existSyntheticClass = this.session.getLookup().getClass(syntheticClassFullName2);
            if (existSyntheticClass.getLocation() instanceof TypeInInputLibraryLocation && this.session.getTypesToEmit().contains(existSyntheticClass)) {
                this.session.removeTypeToEmit(existSyntheticClass);
                this.deletedLibSyntheticClasses.put(syntheticClassFullName2, existSyntheticClass);
            }
        }
        catch (JTypeLookupException syntheticClassFullName2) {
            // empty catch block
        }
        if (syntheticClass != null && !syntheticClassName.equals(syntheticClass.getName())) {
            syntheticClassFullName2 = "L" + BinaryQualifiedNameFormatter.getFormatter().getName(syntheticClass) + ";";
            if (this.deletedLibSyntheticClasses.containsKey(syntheticClassFullName2)) {
                this.session.addTypeToEmit(this.deletedLibSyntheticClasses.remove(syntheticClassFullName2));
            }
            syntheticClass.setName(syntheticClassName);
        } else if (syntheticClass == null) {
            syntheticClass = this.checkAndInitializeSyntheticClass(syntheticClassPackage, syntheticClassName);
            this.syntheticClassMap.put(syntheticClassPackage, syntheticClass);
            this.statisticTracer.getStatistic(SYNTHETIC_SWITCHMAP_CLASS).incValue();
        }
        return syntheticClass;
    }

    @Nonnull
    private JDefinedClass checkAndInitializeSyntheticClass(@Nonnull JPackage enclosingPackage, @Nonnull String syntheticClassShortName) {
        JDefinedClass syntheticClass = null;
        boolean needSyntheticClass = false;
        try {
            syntheticClass = (JDefinedClass)enclosingPackage.getType(syntheticClassShortName);
            if (syntheticClass.getLocation() instanceof TypeInInputLibraryLocation && !this.session.getTypesToEmit().contains(syntheticClass)) {
                needSyntheticClass = true;
            }
        }
        catch (JTypeLookupException e) {
            needSyntheticClass = true;
        }
        if (needSyntheticClass) {
            syntheticClass = this.initializeSyntheticClass(enclosingPackage, syntheticClassShortName);
        }
        assert (syntheticClass != null);
        return syntheticClass;
    }

    @Nonnull
    private JDefinedClass initializeSyntheticClass(@Nonnull JPackage enclosingPackage, @Nonnull String syntheticClassShortName) {
        JDefinedClass syntheticSwitchmapClass = new JDefinedClass(SourceInfo.UNKNOWN, syntheticClassShortName, 4113, enclosingPackage, NopClassOrInterfaceLoader.INSTANCE);
        syntheticSwitchmapClass.setSuperClass(this.session.getLookup().getClass(CommonTypes.JAVA_LANG_OBJECT));
        this.session.addTypeToEmit(syntheticSwitchmapClass);
        return syntheticSwitchmapClass;
    }

    private boolean isOptimizationWorthwhile(int uses, @Nonnull Set<JDefinedEnum> enumsType) {
        int enumFields = 0;
        for (JDefinedEnum enumType : enumsType) {
            EnumFieldMarker enumFieldMarker = enumType.getMarker(EnumFieldMarker.class);
            assert (enumFieldMarker != null);
            enumFields += enumFieldMarker.getEnumFields().size();
        }
        if ((enumFields /= enumsType.size()) >= 1 && enumFields < 4 && uses >= 3) {
            return true;
        }
        return enumFields >= 4 && uses >= 2;
    }

    @Nonnull
    private Set<JDefinedEnum> getPredefinedEnumsType(@Nonnull JDefinedClassOrInterface syntheticClass) {
        HashSet<JDefinedEnum> enumsType = Sets.newHashSet();
        for (JField definedField : syntheticClass.getFields()) {
            if (!this.supportUtil.isSyntheticSwitchMapField(definedField)) continue;
            String enumName = OptimizationUtil.getEnumNameFromSyntheticField(definedField);
            JDefinedClass enumType = null;
            try {
                enumType = this.session.getLookup().getClass(enumName);
            }
            catch (JTypeLookupException e) {
                continue;
            }
            assert (enumType instanceof JDefinedEnum);
            enumsType.add((JDefinedEnum)enumType);
        }
        return enumsType;
    }

    @Nonnull
    private String getSyntheticClassUUID(@Nonnull Set<JDefinedEnum> enumsType) {
        MessageDigest md;
        ArrayList<JDefinedEnum> sortedEnumsType = Lists.newArrayList(enumsType);
        Collections.sort(sortedEnumsType, new Comparator<JDefinedEnum>(){

            @Override
            public int compare(JDefinedEnum enum1, JDefinedEnum enum2) {
                String enumName1 = BinaryQualifiedNameFormatter.getFormatter().getName(enum1);
                String enumName2 = BinaryQualifiedNameFormatter.getFormatter().getName(enum2);
                return enumName1.compareTo(enumName2);
            }
        });
        StringBuilder sb = new StringBuilder();
        for (JDefinedEnum sortedEnumType : sortedEnumsType) {
            EnumFieldMarker enumFieldMarker = sortedEnumType.getMarker(EnumFieldMarker.class);
            assert (enumFieldMarker != null);
            sb.append(Jack.getLookupFormatter().getName(sortedEnumType));
            sb.append(':');
            enumFieldMarker.sortEnumFields();
            List<JEnumField> sortedEnumFields = enumFieldMarker.getEnumFields();
            for (JEnumField enumField : sortedEnumFields) {
                sb.append(enumField.getName());
                sb.append(',');
            }
            sb.append('.');
        }
        String sig = sb.toString();
        sb.delete(0, sb.length());
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        byte[] uuid = md.digest(sig.getBytes());
        for (int i = 0; i < uuid.length; ++i) {
            String hexString = Integer.toHexString(0xFF & uuid[i]);
            if (hexString.length() == 1) {
                sb.append('0');
            }
            sb.append(hexString);
        }
        return sb.toString();
    }

    @CheckForNull
    private JDefinedClass getSyntheticClassUnderPackage(@Nonnull JPackage syntheticClassPackage) {
        for (JDefinedClassOrInterface classOrInterface : syntheticClassPackage.getTypes()) {
            String className = classOrInterface.getName();
            if (!className.startsWith(SyntheticSwitchmapClassNamePrefix)) continue;
            assert (classOrInterface instanceof JDefinedClass);
            if (classOrInterface.getLocation() instanceof TypeInInputLibraryLocation) continue;
            return (JDefinedClass)classOrInterface;
        }
        return null;
    }

    private void initEnumFieldMarkers(@Nonnull Set<JDefinedEnum> enumsType) {
        for (JDefinedEnum enumType : enumsType) {
            if (enumType.containsMarker(EnumFieldMarker.class)) continue;
            EnumFieldMarker enumFieldMarker = new EnumFieldMarker();
            enumType.addMarker(enumFieldMarker);
            for (JField enumField : enumType.getFields()) {
                if (!(enumField instanceof JEnumField)) continue;
                enumFieldMarker.addEnumField((JEnumField)enumField);
            }
        }
    }
}

