/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.exceptions;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.finallyblock.InlinedFinallyMarker;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Replaces try/catch statement by lower exception support.")
@Name(value="TryCatchRemover")
@Constraint(need={NoImplicitBlock.class, JTryStatement.class, InlinedFinallyMarker.class}, no={JTryStatement.FinallyBlock.class})
@Transform(add={JLabel.class, JBlock.class, JLabeledStatement.class, JGoto.class}, remove={JTryStatement.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class TryCatchRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JClass jlo = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final Stack<TryStmtCatchingExceptions> tries = new Stack();
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JStatement stmt) {
            this.addCatchesToStmt(stmt);
            return super.visit(stmt);
        }

        @Override
        public boolean visit(@Nonnull JBlock jBlock) {
            InlinedFinallyMarker marker = jBlock.getMarker(InlinedFinallyMarker.class);
            if (marker != null) {
                this.tries.push(new TryStmtCatchingExceptions(marker.getTryStmt(), true));
            }
            return super.visit(jBlock);
        }

        @Override
        public void endVisit(@Nonnull JBlock jBlock) {
            InlinedFinallyMarker marker = jBlock.getMarker(InlinedFinallyMarker.class);
            if (marker != null) {
                this.tries.pop();
            }
            super.endVisit(jBlock);
        }

        @Override
        public boolean visit(@Nonnull JTryStatement jTry) {
            this.tries.push(new TryStmtCatchingExceptions(jTry, false));
            this.accept(jTry.getTryBlock());
            this.tries.pop();
            this.accept(jTry.getCatchBlocks());
            return false;
        }

        @Override
        public void endVisit(@Nonnull JTryStatement jTry) {
            JStatement lastStmtInTry;
            JStatement nextStatement = ControlFlowHelper.getNextStatement(jTry);
            List<JStatement> stmtsInTry = jTry.getTryBlock().getStatements();
            JStatement jStatement = lastStmtInTry = stmtsInTry.size() > 0 ? stmtsInTry.get(stmtsInTry.size() - 1) : null;
            if (!(nextStatement == null || (lastStmtInTry instanceof JReturnStatement || lastStmtInTry instanceof JThrowStatement || lastStmtInTry instanceof JGoto) && stmtsInTry.size() != 0)) {
                JLabel label = new JLabel(nextStatement.getSourceInfo(), "L" + nextStatement.getSourceInfo().getStartLine());
                JBlock labeledBlock = new JBlock(nextStatement.getSourceInfo());
                labeledBlock.addStmt(nextStatement);
                JLabeledStatement labeledStmt = new JLabeledStatement(nextStatement.getSourceInfo(), label, labeledBlock);
                JGoto branchOnNextStatement = new JGoto(SourceInfo.UNKNOWN, labeledStmt);
                this.tr.append(new Replace(nextStatement, labeledStmt));
                this.tr.append(new AppendStatement(jTry.getTryBlock(), branchOnNextStatement));
            }
            for (JCatchBlock bb : jTry.getCatchBlocks()) {
                this.tr.append(new PrependAfter(jTry, bb));
            }
            this.tr.append(new Replace(jTry, jTry.getTryBlock()));
            super.endVisit(jTry);
        }

        private void addCatchesToStmt(@Nonnull JStatement stmt) {
            TryStmtCatchingExceptions tryStmtCatchingException;
            JTryStatement tryUsedToCatchException;
            ArrayList<JClass> catchTypes = new ArrayList<JClass>();
            ListIterator tryStmtIt = this.tries.listIterator(this.tries.size());
            block0: while (tryStmtIt.hasPrevious() && (tryUsedToCatchException = (tryStmtCatchingException = (TryStmtCatchingExceptions)tryStmtIt.previous()).tryStmt) != null) {
                if (tryStmtCatchingException.isStartingPoint) {
                    JTryStatement tryStatementToFound = tryUsedToCatchException;
                    assert (tryStmtIt.hasPrevious());
                    tryStmtCatchingException = (TryStmtCatchingExceptions)tryStmtIt.previous();
                    while (tryStmtIt.hasPrevious() && tryStmtCatchingException.tryStmt != tryStatementToFound) {
                        tryStmtCatchingException = (TryStmtCatchingExceptions)tryStmtIt.previous();
                        tryUsedToCatchException = tryStmtCatchingException.tryStmt;
                    }
                    assert (tryStmtCatchingException.tryStmt == tryStatementToFound);
                }
                assert (tryUsedToCatchException != null);
                for (JCatchBlock bb : tryUsedToCatchException.getCatchBlocks()) {
                    int catchTypesCount = catchTypes.size();
                    for (JClass catchedType : bb.getCatchTypes()) {
                        if (catchedType.isSameType(TryCatchRemover.this.jlo)) {
                            assert (bb.getCatchTypes().size() == 1);
                            stmt.appendCatchBlock(bb);
                            break block0;
                        }
                        if (catchTypes.contains(catchedType)) continue;
                        catchTypes.add(catchedType);
                    }
                    if (catchTypesCount == catchTypes.size()) continue;
                    stmt.appendCatchBlock(bb);
                }
            }
        }

        private class TryStmtCatchingExceptions {
            @CheckForNull
            private final JTryStatement tryStmt;
            private final boolean isStartingPoint;

            public TryStmtCatchingExceptions(JTryStatement tryStmt, boolean isStartingPoint) {
                this.tryStmt = tryStmt;
                this.isStartingPoint = isStartingPoint;
            }
        }
    }
}

