/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.finallyblock;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JTryStatement;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Inlined finally block.")
@ValidOn(value={JBlock.class})
public final class InlinedFinallyMarker
implements Marker {
    @CheckForNull
    private JTryStatement tryStmt;
    private final boolean catchIntoFinally;

    public InlinedFinallyMarker(@CheckForNull JTryStatement tryStmt, boolean catchIntoFinally) {
        this.tryStmt = tryStmt;
        this.catchIntoFinally = catchIntoFinally;
    }

    public boolean isCatchIntoFinally() {
        return this.catchIntoFinally;
    }

    @CheckForNull
    public JTryStatement getTryStmt() {
        return this.tryStmt;
    }

    public void setTryStmt(@Nonnull JTryStatement tryStmt) {
        this.tryStmt = tryStmt;
    }

    @Override
    public Marker cloneIfNeeded() {
        return new InlinedFinallyMarker(this.tryStmt, this.catchIntoFinally);
    }
}

