/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.flow;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Replaces loops by if/goto. Replaces continue and break into loops by goto.")
@Name(value="FlowNormalizer")
@Constraint(need={NoImplicitBlock.class})
@Transform(add={JGoto.class, JIfStatement.class, JBlock.class, JLabel.class, JLabeledStatement.class}, remove={JLoop.class, JBreakStatement.class, JContinueStatement.class, ThreeAddressCodeForm.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class FlowNormalizer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor(method);
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnegative
        private int labelId = 0;
        @Nonnull
        private final Stack<JStatement> stmts = new Stack();
        @Nonnull
        private final HashMap<JStatement, JLabeledStatement> continueTargets = new HashMap();
        @Nonnull
        private final HashMap<JStatement, JLabeledStatement> breakTargets = new HashMap();
        @Nonnull
        private final TransformationRequest trRequest;

        private Visitor(@Nonnull JMethod method) {
            this.trRequest = new TransformationRequest(method);
        }

        @Override
        public void endVisit(@Nonnull JMethod x) {
            super.endVisit(x);
            this.trRequest.commit();
            this.continueTargets.clear();
            this.breakTargets.clear();
        }

        @Override
        public boolean visit(@Nonnull JStatement statement) {
            this.stmts.push(statement);
            return super.visit(statement);
        }

        @Override
        public void endVisit(@Nonnull JStatement statement) {
            assert (statement == this.stmts.peek());
            this.stmts.pop();
            super.endVisit(statement);
        }

        @Override
        public boolean visit(@Nonnull JBreakStatement breakStmt) {
            JLabeledStatement target = this.findTarget(breakStmt.getLabel(), this.breakTargets);
            this.trRequest.append(new Replace(breakStmt, new JGoto(breakStmt.getSourceInfo(), target)));
            return super.visit(breakStmt);
        }

        @Override
        public boolean visit(@Nonnull JContinueStatement continueStmt) {
            JLabeledStatement target = this.findTarget(continueStmt.getLabel(), this.continueTargets);
            this.trRequest.append(new Replace(continueStmt, new JGoto(continueStmt.getSourceInfo(), target)));
            return super.visit(continueStmt);
        }

        @Override
        public boolean visit(@Nonnull JForStatement forStmt) {
            JBlock loopBody;
            SourceInfo loopSrcInfo = forStmt.getSourceInfo();
            this.registerBreakTarget(forStmt, this.splitBlockOnStatement("for.break", forStmt));
            for (JStatement initializer : forStmt.getInitializers()) {
                this.trRequest.append(new AppendBefore(forStmt, initializer));
            }
            JLabeledStatement condLabeledStmt = this.createLabeledBlock("for.cond", loopSrcInfo);
            JBlock condLabeledBlock = (JBlock)condLabeledStmt.getBody();
            JExpression condExpr = forStmt.getTestExpr();
            if (condExpr instanceof JBooleanLiteral) {
                assert (((JBooleanLiteral)condExpr).getValue());
                loopBody = condLabeledBlock;
            } else {
                loopBody = new JBlock(loopSrcInfo);
                JIfStatement ifStmt = new JIfStatement(loopSrcInfo, forStmt.getTestExpr(), loopBody, null);
                condLabeledBlock.addStmt(ifStmt);
            }
            loopBody.addStmt(forStmt.getBody());
            this.trRequest.append(new AppendBefore(forStmt, condLabeledStmt));
            JLabeledStatement incLabeledBlock = this.createLabeledBlock("for.inc", loopSrcInfo);
            JBlock incBlock = (JBlock)incLabeledBlock.getBody();
            for (JExpressionStatement increment : forStmt.getIncrements()) {
                incBlock.addStmt(increment);
            }
            incBlock.addStmt(new JGoto(SourceInfo.UNKNOWN, condLabeledStmt));
            loopBody.addStmt(incLabeledBlock);
            this.trRequest.append(new Remove(forStmt));
            this.registerContinueTarget(forStmt, incLabeledBlock);
            return super.visit(forStmt);
        }

        @Override
        public boolean visit(@Nonnull JDoStatement doStmt) {
            this.registerBreakTarget(doStmt, this.splitBlockOnStatement("do.break", doStmt));
            JStatement body = doStmt.getBody();
            assert (body instanceof JBlock);
            SourceInfo bodyInfo = body.getSourceInfo();
            JLabel bodyLabel = new JLabel(bodyInfo, "do.body.label." + this.labelId);
            ++this.labelId;
            JLabeledStatement labeledBody = new JLabeledStatement(bodyInfo, bodyLabel, body);
            JExpression cond = doStmt.getTestExpr();
            SourceInfo condInfo = cond.getSourceInfo();
            JBlock branchBlock = new JBlock(condInfo);
            JLabeledStatement labeledCond = this.createLabeledBlock("do.cond", condInfo);
            JGoto gotoStmt = new JGoto(SourceInfo.UNKNOWN, labeledBody);
            if (cond instanceof JBooleanLiteral) {
                if (((JBooleanLiteral)cond).getValue()) {
                    ((JBlock)labeledCond.getBody()).addStmt(gotoStmt);
                }
            } else {
                branchBlock.addStmt(gotoStmt);
                ((JBlock)labeledCond.getBody()).addStmt(new JIfStatement(condInfo, cond, branchBlock, null));
            }
            this.trRequest.append(new PrependAfter(doStmt, labeledCond));
            this.trRequest.append(new Replace(doStmt, labeledBody));
            this.registerContinueTarget(doStmt, labeledCond);
            return super.visit(doStmt);
        }

        @Override
        public boolean visit(@Nonnull JWhileStatement whileStmt) {
            JBlock newBody;
            this.registerBreakTarget(whileStmt, this.splitBlockOnStatement("while.break", whileStmt));
            JExpression cond = whileStmt.getTestExpr();
            SourceInfo loopInfo = whileStmt.getSourceInfo();
            SourceInfo condInfo = cond.getSourceInfo();
            JLabeledStatement condLabeledStmt = this.createLabeledBlock("while.cond", condInfo);
            JBlock condLabeledBlock = (JBlock)condLabeledStmt.getBody();
            JBlock loopBody = (JBlock)whileStmt.getBody();
            if (cond instanceof JBooleanLiteral) {
                assert (((JBooleanLiteral)cond).getValue());
                newBody = condLabeledBlock;
                newBody.addStmt(loopBody);
            } else {
                newBody = loopBody;
                JIfStatement ifStmt = new JIfStatement(loopInfo, cond, newBody, null);
                condLabeledBlock.addStmt(ifStmt);
            }
            newBody.addStmt(new JGoto(SourceInfo.UNKNOWN, condLabeledStmt));
            this.trRequest.append(new Replace(whileStmt, condLabeledStmt));
            this.registerContinueTarget(whileStmt, condLabeledStmt);
            return super.visit(whileStmt);
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            this.registerBreakTarget(switchStmt, this.splitBlockOnStatement("switch.break", switchStmt));
            return super.visit(switchStmt);
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement labelStmt) {
            this.registerBreakTarget(labelStmt, this.splitBlockOnStatement("label.break", labelStmt));
            return super.visit(labelStmt);
        }

        private void registerContinueTarget(JStatement stmt, JLabeledStatement target) {
            this.continueTargets.put(stmt, target);
        }

        private void registerBreakTarget(JStatement stmt, JLabeledStatement target) {
            this.breakTargets.put(stmt, target);
        }

        @Nonnull
        private JLabeledStatement findTarget(@CheckForNull JLabel label, @Nonnull HashMap<JStatement, JLabeledStatement> targetsMap) {
            if (label == null) {
                return this.findTarget(targetsMap);
            }
            return this.findTargetWithLabel(label, targetsMap);
        }

        private JLabeledStatement findTargetWithLabel(@Nonnull JLabel label, @Nonnull HashMap<JStatement, JLabeledStatement> targetsMap) throws AssertionError {
            ListIterator listIterator = this.stmts.listIterator(this.stmts.size());
            while (listIterator.hasPrevious()) {
                JStatement currentStatement = (JStatement)listIterator.previous();
                if (!(currentStatement instanceof JLabeledStatement) || !((JLabeledStatement)currentStatement).getLabel().getName().equals(label.getName())) continue;
                while (true) {
                    JLabeledStatement target;
                    if ((target = targetsMap.get(currentStatement)) != null) {
                        return target;
                    }
                    if (!listIterator.hasNext()) break;
                    currentStatement = (JStatement)listIterator.next();
                }
                throw new AssertionError((Object)("Break or continue to invalid label " + label.getName()));
            }
            throw new AssertionError((Object)("Break or continue to invalid label " + label.getName()));
        }

        private JLabeledStatement findTarget(@Nonnull HashMap<JStatement, JLabeledStatement> targetsMap) throws AssertionError {
            ListIterator listIterator = this.stmts.listIterator(this.stmts.size());
            while (listIterator.hasPrevious()) {
                JLabeledStatement target = targetsMap.get(listIterator.previous());
                if (target == null) continue;
                return target;
            }
            throw new AssertionError((Object)"Break or continue in invalid location");
        }

        @Nonnull
        private JLabeledStatement splitBlockOnStatement(@Nonnull String labelPrefix, @Nonnull JStatement targetStmt) {
            List<JStatement> statementsToMove = this.getFollowingStatements(targetStmt);
            JLabeledStatement target = this.createLabeledBlock(labelPrefix, targetStmt.getSourceInfo());
            ((JBlock)target.getBody()).addStmts(statementsToMove);
            for (JStatement stmt : statementsToMove) {
                this.trRequest.append(new Remove(stmt));
            }
            this.trRequest.append(new PrependAfter(targetStmt, target));
            return target;
        }

        @Nonnull
        private JLabeledStatement createLabeledBlock(@Nonnull String labelPrefix, @Nonnull SourceInfo srcInfo) {
            JLabel label = new JLabel(srcInfo, labelPrefix + ".label." + this.labelId);
            JBlock labledBlock = new JBlock(srcInfo);
            ++this.labelId;
            return new JLabeledStatement(srcInfo, label, labledBlock);
        }

        @Nonnull
        private List<JStatement> getFollowingStatements(@Nonnull JStatement stmt) {
            JNode parent = stmt.getParent();
            assert (parent instanceof JStatementList);
            JStatementList parentBlock = (JStatementList)parent;
            List<JStatement> stmts = parentBlock.getStatements();
            List<JStatement> statementsToMove = parentBlock.getStatements().subList(stmts.indexOf(stmt) + 1, stmts.size());
            return statementsToMove;
        }
    }
}

