/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.google.common.base.Function;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.collect.Iterables;
import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JPhantomInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.InvalidDefaultBridgeInInterfaceRemoved;
import com.android.jack.transformations.lambda.DefaultBridgeIntoInterface;
import com.android.jack.transformations.lambda.LambdaFromJillMarker;
import com.android.jack.util.AndroidApiLevel;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Add bridges into JLambda that comes from default bridges generated into interfaces")
@Constraint(need={DefaultBridgeIntoInterface.class}, no={InvalidDefaultBridgeInInterfaceRemoved.class})
@Transform(add={JLambda.DefaultBridgeAddedInLambda.class}, modify={JLambda.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@Access(value=JSession.class)
public class DefaultBridgeInLambdaAdder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final AndroidApiLevel androidMinApiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JSession session = Jack.getSession();

    @Override
    public void run(@Nonnull JMethod method) {
        if (this.androidMinApiLevel.getReleasedLevel() >= AndroidApiLevel.ReleasedLevel.N.getLevel() || method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JLambda lambdaExpr) {
            if (lambdaExpr.getMarker(LambdaFromJillMarker.class) != null && lambdaExpr.getBridgeMethodIds().isEmpty()) {
                ArrayList<JPhantomInterface> unknownInterfaces = new ArrayList<JPhantomInterface>();
                boolean bridgesFound = this.addDefaultBridges(lambdaExpr, lambdaExpr.getType(), unknownInterfaces);
                if (!bridgesFound && !unknownInterfaces.isEmpty()) {
                    DefaultBridgeInLambdaAdder.this.session.getReporter().report(Reporter.Severity.FATAL, new LambdaUnknownInterfaceReportable(lambdaExpr, unknownInterfaces));
                    DefaultBridgeInLambdaAdder.this.session.abortEventually();
                }
            }
            return false;
        }

        private boolean addDefaultBridges(@Nonnull JLambda lambdaExpr, @Nonnull JInterface interfaze, @Nonnull List<JPhantomInterface> unknownInterfaces) {
            boolean bridgeFound;
            block4: {
                JInterface superInterface;
                block3: {
                    bridgeFound = false;
                    if (!(interfaze instanceof JPhantomInterface)) break block3;
                    unknownInterfaces.add((JPhantomInterface)interfaze);
                    break block4;
                }
                JDefinedInterface definedInterface = (JDefinedInterface)interfaze;
                for (JMethod method : definedInterface.getMethods()) {
                    int mthModifier = method.getModifier();
                    if (!JModifier.isSynthetic(mthModifier) || !JModifier.isBridge(mthModifier)) continue;
                    JMethodId mthIdToAdd = method.getMethodId();
                    JMethodIdWide mthIdWideToAdd = mthIdToAdd.getMethodIdWide();
                    boolean bridgeAlreadyExists = false;
                    for (JMethodId bridge : lambdaExpr.getBridgeMethodIds()) {
                        if (!bridge.getMethodIdWide().equals(mthIdWideToAdd.getName(), mthIdWideToAdd.getParamTypes()) || !bridge.getType().equals(mthIdToAdd.getType())) continue;
                        bridgeAlreadyExists = true;
                        break;
                    }
                    if (bridgeAlreadyExists) continue;
                    bridgeFound = true;
                    lambdaExpr.addBridgeMethodId(method.getMethodId());
                }
                if (bridgeFound) break block4;
                Iterator<HasSourceInfo> iterator = definedInterface.getImplements().iterator();
                while (iterator.hasNext() && !(bridgeFound = this.addDefaultBridges(lambdaExpr, superInterface = (JInterface)iterator.next(), unknownInterfaces))) {
                }
            }
            return bridgeFound;
        }
    }

    private static class LambdaUnknownInterfaceReportable
    implements Reportable,
    HasSourceInfo {
        @Nonnull
        private static final Joiner typeNameJoiner = Joiner.on(", ");
        @Nonnull
        private final List<JPhantomInterface> unknownInterfaces;
        @Nonnull
        private final JLambda lambda;

        public LambdaUnknownInterfaceReportable(@Nonnull JLambda lambda, List<JPhantomInterface> unknownTypes) {
            this.lambda = lambda;
            this.unknownInterfaces = unknownTypes;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Lambda coming from jar file need their interfaces on the classpath to be compiled, unknown interfaces are " + typeNameJoiner.join(Iterables.transform(this.unknownInterfaces, new Function<JPhantomInterface, String>(){

                @Override
                public String apply(JPhantomInterface arg0) {
                    return Jack.getUserFriendlyFormatter().getName(arg0);
                }
            }));
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }

        @Override
        public SourceInfo getSourceInfo() {
            return this.lambda.getSourceInfo();
        }
    }
}

