/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.google.common.collect.Lists;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.transformations.lambda.LambdaCaptureSignature;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

final class LambdaGroup {
    @Nonnull
    private final List<JLambda> lambdas;
    @Nonnull
    private final JDefinedClass groupClass;
    @Nonnull
    private final LambdaCaptureSignature captureSignature;

    LambdaGroup(@Nonnull Map<String, JLambda> lambdas, @Nonnull JDefinedClass groupClass, @Nonnull LambdaCaptureSignature captureSignature) {
        this.lambdas = LambdaGroup.inStableOrder(lambdas);
        this.groupClass = groupClass;
        this.captureSignature = captureSignature;
    }

    @Nonnull
    private static List<JLambda> inStableOrder(@Nonnull Map<String, JLambda> lambdas) {
        return Lists.newArrayList(new TreeMap<String, JLambda>(lambdas).values());
    }

    @Nonnull
    List<JLambda> getLambdas() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.lambdas);
    }

    @Nonnull
    JDefinedClass getGroupClass() {
        return this.groupClass;
    }

    @Nonnull
    LambdaCaptureSignature getCaptureSignature() {
        return this.captureSignature;
    }
}

