/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdRef;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.lambda.LambdaCaptureSignature;
import com.android.jack.transformations.lambda.LambdaGroup;
import com.android.jack.transformations.lambda.LambdaGroupMarker;
import com.android.jack.transformations.lambda.LambdaInfoMarker;
import com.android.jack.transformations.lambda.LambdaInterfaceSignature;
import com.android.jack.transformations.lambda.LambdaToAnonymousConverter;
import com.android.jack.transformations.request.AppendField;
import com.android.jack.transformations.request.AppendMethod;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Lambdas optimization, finishing lambda group classes construction")
@Constraint(need={LambdaGroupMarker.class})
@Transform(add={JAsgOperation.class, JBlock.class, JByteLiteral.class, JConstructor.class, JDynamicCastOperation.class, JField.class, JFieldRef.class, JIntLiteral.class, JMethod.class, JMethodBody.class, JMethodCall.class, JNewInstance.class, JParameter.class, JParameterRef.class, JReturnStatement.class, JShortLiteral.class, JSwitchStatement.class, JThisRef.class, JThrowStatement.class, LambdaInfoMarker.class}, remove={NewInstanceRemoved.class})
@ExclusiveAccess(value=JSession.class)
@Support(value={LambdaToAnonymousConverter.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public final class LambdaGroupClassFinalizer
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private static final TypePackageAndMethodFormatter FORMATTER = Jack.getLookupFormatter();
    private final boolean simplifyStateless = ThreadConfig.get(Options.LAMBDA_SIMPLIFY_STATELESS);
    private final boolean mergeInterfaces = ThreadConfig.get(Options.LAMBDA_MERGE_INTERFACES);
    @Nonnull
    private final JPhantomLookup phantomLookup = Jack.getSession().getPhantomLookup();
    @Nonnull
    private final JClass javaLangObject = this.phantomLookup.getClass(CommonTypes.JAVA_LANG_OBJECT);
    @Nonnull
    private final JClass javaLangAssertionError = this.phantomLookup.getClass(CommonTypes.JAVA_LANG_ASSERTION_ERROR);

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        LambdaGroupMarker infoMarker = type.getMarker(LambdaGroupMarker.class);
        if (infoMarker == null) {
            return;
        }
        assert (type instanceof JDefinedClass);
        new Builder(infoMarker.getGroup()).build();
    }

    private class Builder {
        @Nonnull
        final TransformationRequest request;
        @Nonnull
        final LambdaGroup group;
        @Nonnull
        final List<JField> captureFields;
        @Nonnull
        final List<JField> staticFields = new ArrayList<JField>();
        @CheckForNull
        final JField idField;
        @Nonnull
        final TreeMap<String, MethodGroupData> methodGroups = new TreeMap();

        Builder(LambdaGroup group) {
            int i;
            JDefinedClass groupClass = group.getGroupClass();
            List<JLambda> lambdas = group.getLambdas();
            LambdaCaptureSignature capture = group.getCaptureSignature();
            this.request = new TransformationRequest(groupClass);
            this.group = group;
            this.captureFields = capture.createFields(groupClass, LambdaGroupClassFinalizer.this.javaLangObject);
            int size = lambdas.size();
            if (LambdaGroupClassFinalizer.this.simplifyStateless && this.captureFields.isEmpty()) {
                for (i = 0; i < size; ++i) {
                    this.staticFields.add(new JField(SourceInfo.UNKNOWN, "$INST$" + i, groupClass, groupClass, 4121));
                }
            }
            assert (size > 0);
            if (size == 1) {
                JLambda lambda = lambdas.get(0);
                lambda.addMarker(new LambdaInfoMarker(groupClass, this.hasStaticFields() ? this.staticFields.get(0) : null, -1, capture.createMapping(lambda)));
                this.idField = null;
            } else {
                for (i = 0; i < size; ++i) {
                    JLambda lambda = lambdas.get(i);
                    lambda.addMarker(new LambdaInfoMarker(groupClass, this.hasStaticFields() ? this.staticFields.get(i) : null, i, capture.createMapping(lambda)));
                }
                this.idField = this.createIdField(groupClass, size);
            }
        }

        private boolean hasStaticFields() {
            return !this.staticFields.isEmpty();
        }

        @Nonnull
        private JField createIdField(@Nonnull JDefinedClass groupClass, @Nonnegative int size) {
            JPrimitiveType type = size <= 127 ? JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() : (size <= Short.MAX_VALUE ? JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() : JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
            return new JField(SourceInfo.UNKNOWN, "$id", groupClass, type, 4114);
        }

        void build() {
            JDefinedClass groupClass = this.group.getGroupClass();
            for (JInterface inter : this.getInterfaces()) {
                groupClass.addImplements(inter);
            }
            if (this.idField != null) {
                this.request.append(new AppendField(groupClass, this.idField));
            }
            for (JField field : this.captureFields) {
                this.request.append(new AppendField(groupClass, field));
            }
            for (JField field : this.staticFields) {
                this.request.append(new AppendField(groupClass, field));
            }
            JConstructor constructor = this.createConstructor();
            if (this.hasStaticFields()) {
                this.createStaticConstructor(constructor);
            }
            this.createAllForwardingMethods();
            for (MethodGroupData data : this.methodGroups.values()) {
                this.createMethodGroupDispatchMethod(data);
            }
            this.request.commit();
        }

        @Nonnull
        private List<JInterface> getInterfaces() {
            List<JLambda> lambdas = this.group.getLambdas();
            if (LambdaGroupClassFinalizer.this.mergeInterfaces) {
                return LambdaInterfaceSignature.normalizeInterfaces(lambdas);
            }
            assert (lambdas.size() > 0);
            return LambdaInterfaceSignature.extractOrderedInterfaces(lambdas.get(0));
        }

        private void createStaticConstructor(@Nonnull JConstructor instanceConstructor) {
            assert (this.captureFields.isEmpty());
            assert (!this.staticFields.isEmpty());
            int modifier = 69640;
            JMethodIdWide methodIdWide = new JMethodIdWide("<clinit>", MethodKind.STATIC);
            JMethodId methodId = new JMethodId(methodIdWide, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
            JMethod constructor = new JMethod(SourceInfo.UNKNOWN, methodId, this.group.getGroupClass(), modifier);
            this.request.append(new AppendMethod(this.group.getGroupClass(), constructor));
            JBlock block = new JBlock(SourceInfo.UNKNOWN);
            JMethodBody body = new JMethodBody(SourceInfo.UNKNOWN, block);
            constructor.setBody(body);
            body.updateParents(constructor);
            List<JLambda> lambdas = this.group.getLambdas();
            assert (this.staticFields.size() == lambdas.size());
            for (int i = 0; i < this.staticFields.size(); ++i) {
                JField field = this.staticFields.get(i);
                JLambda lambda = lambdas.get(i);
                LambdaInfoMarker marker = lambda.getMarker(LambdaInfoMarker.class);
                assert (marker != null);
                JNewInstance newInstance = marker.createGroupClassInstance(this.request, instanceConstructor, Collections.emptyList(), SourceInfo.UNKNOWN);
                this.createAssignStatement(block, null, field.getId(), newInstance);
            }
            this.request.append(new AppendStatement(block, new JReturnStatement(SourceInfo.UNKNOWN, null)));
        }

        @Nonnull
        private JConstructor createConstructor() {
            int modifier = this.hasStaticFields() ? 2 : 1;
            JConstructor constructor = new JConstructor(SourceInfo.UNKNOWN, this.group.getGroupClass(), modifier | 0x1000);
            this.request.append(new AppendMethod(this.group.getGroupClass(), constructor));
            ArrayList<Object> params = new ArrayList<Object>();
            if (this.idField != null) {
                JParameter param = new JParameter(this.idField.getSourceInfo(), NamingTools.getNonSourceConflictingName("p" + this.idField.getName()), this.idField.getType(), 4096, constructor);
                params.add(param);
                this.addParam(constructor, param);
            }
            for (JField field : this.captureFields) {
                JParameter param = new JParameter(field.getSourceInfo(), NamingTools.getNonSourceConflictingName("p" + field.getName()), field.getType(), 4096, constructor);
                params.add(param);
                this.addParam(constructor, param);
            }
            JBlock block = new JBlock(SourceInfo.UNKNOWN);
            JMethodBody body = new JMethodBody(SourceInfo.UNKNOWN, block);
            constructor.setBody(body);
            body.updateParents(constructor);
            JThis thisLocal = constructor.getThis();
            assert (thisLocal != null);
            JMethodId superConstructor = LambdaGroupClassFinalizer.this.javaLangObject.getOrCreateMethodId("<init>", Collections.emptyList(), MethodKind.INSTANCE_NON_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
            JMethodCall superCall = new JMethodCall(SourceInfo.UNKNOWN, thisLocal.makeRef(SourceInfo.UNKNOWN), LambdaGroupClassFinalizer.this.javaLangObject, superConstructor, false);
            this.request.append(new AppendStatement(block, superCall.makeStatement()));
            int paramIdx = 0;
            if (this.idField != null) {
                this.createAssignStatement(block, thisLocal, this.idField.getId(), (JParameter)params.get(paramIdx++));
            }
            for (JField field : this.captureFields) {
                this.createAssignStatement(block, thisLocal, field.getId(), (JParameter)params.get(paramIdx++));
            }
            this.request.append(new AppendStatement(block, new JReturnStatement(SourceInfo.UNKNOWN, null)));
            return constructor;
        }

        private void addParam(@Nonnull JMethod method, @Nonnull JParameter param) {
            method.addParam(param);
            method.getMethodIdWide().addParam(param.getType());
            param.updateParents(method);
        }

        private void createAssignStatement(@Nonnull JBlock block, @Nonnull JThis thisLocal, @Nonnull JFieldId fieldId, @Nonnull JParameter param) {
            this.createAssignStatement(block, thisLocal.makeRef(SourceInfo.UNKNOWN), fieldId, param.makeRef(SourceInfo.UNKNOWN));
        }

        private void createAssignStatement(@Nonnull JBlock block, @CheckForNull JExpression instance, @Nonnull JFieldId fieldId, @Nonnull JExpression rhs) {
            JFieldRef fieldRef = new JFieldRef(SourceInfo.UNKNOWN, instance, fieldId, this.group.getGroupClass());
            JAsgOperation assignment = new JAsgOperation(SourceInfo.UNKNOWN, fieldRef, rhs);
            this.request.append(new AppendStatement(block, assignment.makeStatement()));
        }

        @Nonnull
        private String getSignature(@Nonnull JMethodId id) {
            JMethodIdWide idWide = id.getMethodIdWide();
            return FORMATTER.getName(idWide.getName(), idWide.getParamTypes(), id.getType());
        }

        private void createAllForwardingMethods() {
            int nextUniqueId = 0;
            TreeMap<String, JMethodId> sortedIds = new TreeMap<String, JMethodId>();
            for (JLambda lambda : this.group.getLambdas()) {
                JMethodId methodIdWithErasure = lambda.getMethodIdWithErasure();
                JMethodId methodIdWithoutErasure = lambda.getMethodIdWithoutErasure();
                JMethod mainMethod = this.createEmptyForwardingMethod(lambda, methodIdWithErasure, nextUniqueId++, false);
                sortedIds.clear();
                for (JMethodId bridgeMethodId : lambda.getBridgeMethodIds()) {
                    sortedIds.put(this.getSignature(bridgeMethodId), bridgeMethodId);
                }
                for (JMethodId bridgeMethodId : sortedIds.values()) {
                    JMethod bridge = this.createEmptyForwardingMethod(lambda, bridgeMethodId, nextUniqueId++, true);
                    this.delegateBridgingCall(bridge, mainMethod, methodIdWithoutErasure);
                }
                JMethodIdRef lambdaMethodIdRef = lambda.getMethodIdRef();
                JMethodId methodId = lambdaMethodIdRef.getMethodId();
                JMethod lambdaMethod = lambdaMethodIdRef.getEnclosingType().getMethod(methodId);
                LambdaInfoMarker marker = lambda.getMarker(LambdaInfoMarker.class);
                assert (marker != null);
                this.delegateLambdaCall(mainMethod, lambdaMethod, methodIdWithoutErasure, lambda.getCapturedVariables(), marker.getCaptureMapping());
            }
        }

        @Nonnull
        private JExpression getFieldRef(@Nonnegative int index, @Nonnull JType type, @Nonnull JThisRef ref) {
            assert (index < this.captureFields.size());
            JFieldRef fieldRef = new JFieldRef(SourceInfo.UNKNOWN, ref, this.captureFields.get(index).getId(), this.group.getGroupClass());
            if (type instanceof JPrimitiveType) {
                assert (fieldRef.getType() == type);
                return fieldRef;
            }
            return LambdaGroupClassFinalizer.this.javaLangObject.isSameType(type) ? fieldRef : new JDynamicCastOperation(SourceInfo.UNKNOWN, (JExpression)fieldRef, type);
        }

        private void delegateBridgingCall(@Nonnull JMethod caller, @Nonnull JMethod callee, @Nonnull JMethodId enforcedId) {
            JThis callerThis = caller.getThis();
            assert (callerThis != null);
            this.delegateCallImpl(caller, callee, enforcedId, callerThis.makeRef(SourceInfo.UNKNOWN), null);
        }

        private void delegateLambdaCall(@Nonnull JMethod caller, @Nonnull JMethod callee, @Nonnull JMethodId enforcedId, @Nonnull List<JExpression> captures, @Nonnull int[] mapping) {
            int capturesCount = captures.size();
            assert (mapping.length == capturesCount);
            JThis callerThis = caller.getThis();
            assert (callerThis != null);
            JExpression[] captureFields = new JExpression[capturesCount];
            for (int idx = 0; idx < capturesCount; ++idx) {
                captureFields[idx] = this.getFieldRef(mapping[idx], captures.get(idx).getType(), callerThis.makeRef(SourceInfo.UNKNOWN));
            }
            boolean calleeNeedsInstance = !callee.isStatic();
            int captureStart = calleeNeedsInstance ? 1 : 0;
            JExpression calleeThisRef = calleeNeedsInstance ? captureFields[0] : null;
            List<JExpression> extraArgs = null;
            if (capturesCount > captureStart) {
                extraArgs = Arrays.asList(captureFields).subList(captureStart, capturesCount);
            }
            this.delegateCallImpl(caller, callee, enforcedId, calleeThisRef, extraArgs);
        }

        private void delegateCallImpl(@Nonnull JMethod caller, @Nonnull JMethod callee, @Nonnull JMethodId enforcedId, @CheckForNull JExpression calleeThisRef, @CheckForNull List<JExpression> extraArgs) {
            JBlock bodyBlock = new JBlock(SourceInfo.UNKNOWN);
            JMethodBody body = new JMethodBody(SourceInfo.UNKNOWN, bodyBlock);
            JMethodCall call = new JMethodCall(SourceInfo.UNKNOWN, calleeThisRef, callee.getEnclosingType(), callee.getMethodId(), !callee.isStatic() && !callee.isPrivate());
            List<JParameter> callerParams = caller.getParams();
            List<JParameter> calleeParams = callee.getParams();
            assert (calleeParams.size() == callerParams.size() + (extraArgs == null ? 0 : extraArgs.size()));
            if (extraArgs != null) {
                call.addArgs(extraArgs);
            }
            List<JType> enforcedTypes = enforcedId.getMethodIdWide().getParamTypes();
            int idx = 0;
            for (JParameter param : callerParams) {
                call.addArg(new JDynamicCastOperation(SourceInfo.UNKNOWN, (JExpression)param.makeRef(SourceInfo.UNKNOWN), enforcedTypes.get(idx++)));
            }
            if (caller.getType() != JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) {
                bodyBlock.addStmt(new JReturnStatement(SourceInfo.UNKNOWN, call));
            } else {
                bodyBlock.addStmt(new JExpressionStatement(SourceInfo.UNKNOWN, call));
                bodyBlock.addStmt(new JReturnStatement(SourceInfo.UNKNOWN, null));
            }
            caller.setBody(body);
        }

        @Nonnull
        private JMethod createEmptyForwardingMethod(@Nonnull JLambda lambda, @Nonnull JMethodId origMethodId, @Nonnegative int uniqueSuffix, boolean isBridge) {
            JMethodIdWide origMethodIdWide = origMethodId.getMethodIdWide();
            JMethodIdWide newMethodIdWide = new JMethodIdWide("$m$" + uniqueSuffix, origMethodIdWide.getParamTypes(), MethodKind.INSTANCE_NON_VIRTUAL);
            JMethodId newMethodId = new JMethodId(newMethodIdWide, origMethodId.getType());
            int modifier = 0x1002 | (isBridge ? 64 : 0) | 0x10;
            JMethod newMethod = new JMethod(SourceInfo.UNKNOWN, newMethodId, this.group.getGroupClass(), modifier);
            int idx = 0;
            for (JType type : origMethodIdWide.getParamTypes()) {
                JParameter param = new JParameter(SourceInfo.UNKNOWN, "arg" + idx++, type, 0, newMethod);
                newMethod.addParam(param);
                param.updateParents(newMethod);
            }
            String signature = this.getSignature(origMethodId);
            MethodGroupData data = this.methodGroups.get(signature);
            if (data == null) {
                data = new MethodGroupData(origMethodId);
                this.methodGroups.put(signature, data);
            }
            data.addMethod(lambda, newMethod);
            this.request.append(new AppendMethod(this.group.getGroupClass(), newMethod));
            return newMethod;
        }

        private void createMethodGroupDispatchMethod(@Nonnull MethodGroupData data) {
            JMethodId origMethodId = data.id;
            JMethodIdWide origMethodIdWide = origMethodId.getMethodIdWide();
            JMethodIdWide newMethodIdWide = new JMethodIdWide(origMethodIdWide.getName(), origMethodIdWide.getParamTypes(), origMethodIdWide.getKind());
            JMethodId newMethodId = new JMethodId(newMethodIdWide, origMethodId.getType());
            JMethod newMethod = new JMethod(SourceInfo.UNKNOWN, newMethodId, this.group.getGroupClass(), 17);
            ArrayList<JParameter> params = new ArrayList<JParameter>();
            for (JType type : origMethodIdWide.getParamTypes()) {
                JParameter newParam = new JParameter(SourceInfo.UNKNOWN, NamingTools.getNonSourceConflictingName("p" + params.size()), type, 4096, newMethod);
                newMethod.addParam(newParam);
                newParam.updateParents(newMethod);
                params.add(newParam);
            }
            JBlock block = new JBlock(SourceInfo.UNKNOWN);
            JMethodBody body = new JMethodBody(SourceInfo.UNKNOWN, block);
            newMethod.setBody(body);
            body.updateParents(newMethod);
            JThis self = newMethod.getThis();
            if (this.idField == null) {
                assert (data.methods.size() == 1);
                this.generateForwardCall(block, self, params, data.methods.get(0));
            } else {
                this.createSwitchBasedDispatch(block, self, params, data);
            }
            this.request.append(new AppendMethod(this.group.getGroupClass(), newMethod));
        }

        private void createSwitchBasedDispatch(@Nonnull JBlock block, @Nonnull JThis self, @Nonnull List<JParameter> params, @Nonnull MethodGroupData data) {
            assert (this.idField != null);
            JPrimitiveType idType = (JPrimitiveType)this.idField.getType();
            JBlock mainSwitchBlock = new JBlock(SourceInfo.UNKNOWN);
            ArrayList<JCaseStatement> cases = new ArrayList<JCaseStatement>();
            int size = data.methods.size();
            for (int idx = 0; idx < size; ++idx) {
                JLambda lambda = data.lambdas.get(idx);
                LambdaInfoMarker marker = lambda.getMarker(LambdaInfoMarker.class);
                assert (marker != null);
                assert (marker.hasId());
                JCaseStatement caseStmt = new JCaseStatement(SourceInfo.UNKNOWN, ((JIntegralType32)((Object)idType)).createLiteral(SourceInfo.UNKNOWN, marker.getId()));
                cases.add(caseStmt);
                this.request.append(new AppendStatement(mainSwitchBlock, caseStmt));
                this.generateForwardCall(mainSwitchBlock, self, params, data.methods.get(idx));
            }
            JCaseStatement defaultCase = new JCaseStatement(SourceInfo.UNKNOWN, null);
            this.request.append(new AppendStatement(mainSwitchBlock, defaultCase));
            JBlock next = new JBlock(SourceInfo.UNKNOWN);
            this.request.append(new AppendStatement(mainSwitchBlock, next));
            JNewInstance newAssertionError = new JNewInstance(SourceInfo.UNKNOWN, LambdaGroupClassFinalizer.this.javaLangAssertionError, LambdaGroupClassFinalizer.this.javaLangAssertionError.getOrCreateMethodId("<init>", Collections.emptyList(), MethodKind.INSTANCE_NON_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()));
            JThrowStatement throwStmt = new JThrowStatement(SourceInfo.UNKNOWN, newAssertionError);
            this.request.append(new AppendStatement(next, throwStmt));
            JFieldRef fieldRef = new JFieldRef(SourceInfo.UNKNOWN, self.makeRef(SourceInfo.UNKNOWN), this.idField.getId(), this.group.getGroupClass());
            JSwitchStatement switchStmt = new JSwitchStatement(SourceInfo.UNKNOWN, fieldRef, mainSwitchBlock, cases, defaultCase);
            this.request.append(new AppendStatement(block, switchStmt));
        }

        private void generateForwardCall(@Nonnull JBlock block, @Nonnull JThis self, @Nonnull List<JParameter> params, @Nonnull JMethod method) {
            JType returnType = method.getType();
            JMethodCall call = new JMethodCall(SourceInfo.UNKNOWN, self.makeRef(SourceInfo.UNKNOWN), this.group.getGroupClass(), method.getMethodId(), false);
            for (JParameter param : params) {
                call.addArg(param.makeRef(SourceInfo.UNKNOWN));
            }
            if (JPrimitiveType.JPrimitiveTypeEnum.VOID.getType().isSameType(returnType)) {
                this.request.append(new AppendStatement(block, call.makeStatement()));
                this.request.append(new AppendStatement(block, new JReturnStatement(SourceInfo.UNKNOWN, null)));
            } else {
                this.request.append(new AppendStatement(block, new JReturnStatement(SourceInfo.UNKNOWN, call)));
            }
        }
    }

    private static class MethodGroupData {
        @Nonnull
        final JMethodId id;
        @Nonnull
        final List<JLambda> lambdas = new ArrayList<JLambda>();
        @Nonnull
        final List<JMethod> methods = new ArrayList<JMethod>();

        MethodGroupData(@Nonnull JMethodId id) {
            this.id = id;
        }

        void addMethod(@Nonnull JLambda lambda, @Nonnull JMethod method) {
            this.lambdas.add(lambda);
            this.methods.add(method);
        }
    }
}

