/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.parent;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import java.util.Stack;
import javax.annotation.Nonnull;

@Description(value="Check that AST of JNodes is correct, running on JDefinedClassOrInterfaces.")
@Support(value={SanityChecks.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class TypeAstChecker
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        Visitor checker = new Visitor();
        checker.accept(type);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final Stack<JNode> nodes = new Stack();

        private Visitor() {
            super(false);
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            assert (!(node instanceof JSession));
            node.checkValidity();
            if (node instanceof JDefinedClassOrInterface) {
                if (node.getParent() == null) {
                    throw new AssertionError((Object)("Parent of " + JDefinedClassOrInterface.class.getName() + " must not be null."));
                }
            } else if (node.getParent() != this.nodes.peek()) {
                throw new AssertionError((Object)"Node with wrong parent.");
            }
            this.nodes.push(node);
            return super.visit(node);
        }

        @Override
        public void endVisit(@Nonnull JNode node) {
            this.nodes.pop();
            super.endVisit(node);
        }
    }
}

