/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.typedef;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.transformations.TypeRemover;
import com.android.sched.item.Description;
import com.android.sched.item.Feature;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.id.BooleanPropertyId;
import javax.annotation.Nonnull;

@Description(value="Removes @StringDef, @IntDef and all annotations annotated with them")
@Synchronized
@Support(value={RemoveTypeDef.class})
@HasKeyId
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(need={JAnnotation.RepeatedAnnotation.class})})})
@ExclusiveAccess(value=JSession.class)
public class TypeDefRemover
extends TypeRemover {
    @Nonnull
    public static final BooleanPropertyId REMOVE_TYPEDEF = BooleanPropertyId.create("jack.android.remove-typedef", "Removes @StringDef, @IntDef and all annotations annotated with them").addDefaultValue(false).addCategory(DumpInLibrary.class);
    @Nonnull
    private final JDefinedAnnotationType stringDef = Jack.getSession().getLookup().getAnnotationType("Landroid/annotation/StringDef;");
    @Nonnull
    private final JDefinedAnnotationType intDef = Jack.getSession().getLookup().getAnnotationType("Landroid/annotation/IntDef;");

    @Override
    protected boolean mustBeRemoved(@Nonnull JDefinedClassOrInterface type) {
        if (type instanceof JDefinedAnnotationType) {
            if (!type.getAnnotations(this.stringDef).isEmpty() || !type.getAnnotations(this.intDef).isEmpty()) {
                JDefinedAnnotationType typeDef = (JDefinedAnnotationType)type;
                if (typeDef.getRetentionPolicy() != JRetentionPolicy.SOURCE) {
                    Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new InvalidRetentionForTypeDef(typeDef));
                }
                return true;
            }
        } else if (!type.getAnnotations(this.stringDef).isEmpty() || !type.getAnnotations(this.intDef).isEmpty()) {
            Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new InvalidTypeDefTarget(type));
        }
        return false;
    }

    @Override
    protected boolean isPlannedForRemoval(@Nonnull JMethod method) {
        return this.mustBeRemoved(method.getEnclosingType());
    }

    private static class InvalidTypeDefTarget
    implements Reportable {
        @Nonnull
        private final JDefinedClassOrInterface annotated;

        public InvalidTypeDefTarget(@Nonnull JDefinedClassOrInterface annotated) {
            this.annotated = annotated;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Type " + Jack.getUserFriendlyFormatter().getName(this.annotated) + " should not be annotated with @IntDef or @StringDef, only annotations are valid targets";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }

    private static class InvalidRetentionForTypeDef
    implements Reportable {
        @Nonnull
        private final JDefinedAnnotationType typeDef;

        public InvalidRetentionForTypeDef(@Nonnull JDefinedAnnotationType typeDef) {
            this.typeDef = typeDef;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Annotation @" + Jack.getUserFriendlyFormatter().getName(this.typeDef) + "should be annotated with @Retention(RetentionPolicy.SOURCE)";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }

    @Description(value="Removes @StringDef, @IntDef and all annotations annotated with them")
    public static class RemoveTypeDef
    implements Feature {
    }
}

