/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import java.util.Random;

public class PoissonGenerator
implements NumberGenerator<Integer> {
    private final Random rng;
    private final NumberGenerator<Double> mean;

    public PoissonGenerator(NumberGenerator<Double> mean, Random rng) {
        this.mean = mean;
        this.rng = rng;
    }

    public PoissonGenerator(double mean, Random rng) {
        this(new ConstantGenerator<Double>(mean), rng);
        if (mean <= 0.0) {
            throw new IllegalArgumentException("Mean must be a positive value.");
        }
    }

    @Override
    public Integer nextValue() {
        int x = 0;
        double t = 0.0;
        while (!((t -= Math.log(this.rng.nextDouble()) / this.mean.nextValue()) > 1.0)) {
            ++x;
        }
        return x;
    }
}

