/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.selection;

import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RouletteWheelSelection
implements SelectionStrategy<Object> {
    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        double[] cumulativeFitnesses = new double[population.size()];
        cumulativeFitnesses[0] = this.getAdjustedFitness(population.get(0).getFitness(), naturalFitnessScores);
        for (int i = 1; i < population.size(); ++i) {
            double fitness = this.getAdjustedFitness(population.get(i).getFitness(), naturalFitnessScores);
            cumulativeFitnesses[i] = cumulativeFitnesses[i - 1] + fitness;
        }
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        for (int i = 0; i < selectionSize; ++i) {
            double randomFitness = rng.nextDouble() * cumulativeFitnesses[cumulativeFitnesses.length - 1];
            int index = Arrays.binarySearch(cumulativeFitnesses, randomFitness);
            if (index < 0) {
                index = Math.abs(index + 1);
            }
            selection.add(population.get(index).getCandidate());
        }
        return selection;
    }

    private double getAdjustedFitness(double rawFitness, boolean naturalFitness) {
        if (naturalFitness) {
            return rawFitness;
        }
        return rawFitness == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / rawFitness;
    }

    public String toString() {
        return "Roulette Wheel Selection";
    }
}

