/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.selection;

import com.android.jack.uncommons.maths.statistics.DataSet;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import com.android.jack.uncommons.watchmaker.framework.selection.StochasticUniversalSampling;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SigmaScaling
implements SelectionStrategy<Object> {
    private final SelectionStrategy<Object> delegate;

    public SigmaScaling() {
        this(new StochasticUniversalSampling());
    }

    public SigmaScaling(SelectionStrategy<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        DataSet statistics = new DataSet(population.size());
        for (EvaluatedCandidate<S> candidate : population) {
            statistics.addValue(candidate.getFitness());
        }
        ArrayList scaledPopulation = new ArrayList(population.size());
        for (EvaluatedCandidate<S> candidate : population) {
            double scaledFitness = this.getSigmaScaledFitness(candidate.getFitness(), statistics.getArithmeticMean(), statistics.getStandardDeviation());
            scaledPopulation.add(new EvaluatedCandidate<S>(candidate.getCandidate(), scaledFitness));
        }
        return this.delegate.select(scaledPopulation, naturalFitnessScores, selectionSize, rng);
    }

    private double getSigmaScaledFitness(double candidateFitness, double populationMeanFitness, double fitnessStandardDeviation) {
        if (fitnessStandardDeviation == 0.0) {
            return 1.0;
        }
        double scaledFitness = 1.0 + (candidateFitness - populationMeanFitness) / (2.0 * fitnessStandardDeviation);
        return scaledFitness > 0.0 ? scaledFitness : 0.1;
    }

    public String toString() {
        return "Sigma Scaling";
    }
}

