/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.sched.util.codec.EnumName;
import com.android.sched.util.codec.VariableName;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AndroidApiLevel {
    @Nonnegative
    private final int releasedLevel;
    @Nonnull
    private final ProvisionalLevel provisionalLevel;

    public AndroidApiLevel(@Nonnegative int level) {
        this.releasedLevel = level;
        this.provisionalLevel = ProvisionalLevel.NONE;
    }

    public AndroidApiLevel(@Nonnull ReleasedLevel level) {
        this.releasedLevel = level.getLevel();
        this.provisionalLevel = ProvisionalLevel.NONE;
    }

    public AndroidApiLevel(@Nonnull ProvisionalLevel provisionalLevel) {
        this.releasedLevel = provisionalLevel.getLevel();
        this.provisionalLevel = provisionalLevel;
    }

    public boolean isReleasedLevel() {
        return this.provisionalLevel == ProvisionalLevel.NONE;
    }

    @Nonnull
    public ProvisionalLevel getProvisionalLevel() {
        return this.provisionalLevel;
    }

    @Nonnegative
    public int getReleasedLevel() {
        return this.releasedLevel;
    }

    @VariableName(value="level")
    public static final class ProvisionalLevel
    extends Enum<ProvisionalLevel> {
        public static final /* enum */ ProvisionalLevel NONE = new ProvisionalLevel(null);
        @EnumName(name="o-b1", description="Dex file 0x37 with invoke-poly")
        public static final /* enum */ ProvisionalLevel O_BETA1 = new ProvisionalLevel(ReleasedLevel.N_MR1);
        @EnumName(name="o-b2", description="Dex file 0x38 with invoke-{poly,custom}")
        public static final /* enum */ ProvisionalLevel O_BETA2 = new ProvisionalLevel(ReleasedLevel.N_MR1);
        @Nonnegative
        private final int level;
        private static final /* synthetic */ ProvisionalLevel[] $VALUES;

        public static ProvisionalLevel[] values() {
            return (ProvisionalLevel[])$VALUES.clone();
        }

        public static ProvisionalLevel valueOf(String name) {
            return Enum.valueOf(ProvisionalLevel.class, name);
        }

        private ProvisionalLevel(ReleasedLevel level) {
            this.level = level != null ? level.getLevel() : 0;
        }

        private int getLevel() {
            return this.level;
        }

        static {
            $VALUES = new ProvisionalLevel[]{NONE, O_BETA1, O_BETA2};
            assert (NONE != null);
        }
    }

    public static enum ReleasedLevel {
        N_MR1(25),
        N(24),
        M(23),
        L_MR1(22),
        L(21),
        K_WATCH(20),
        K(19),
        J_MR2(18),
        J_MR1(17),
        J(16),
        I_MR1(15),
        I(14),
        H_MR2(13),
        H_MR1(12),
        H(11),
        G_MR1(10),
        G(9),
        F(8),
        E_MR1(7),
        E_0_1(6),
        E(5),
        D(4),
        C(3),
        B_1_1(2),
        B(1);

        @Nonnegative
        private final int level;

        private ReleasedLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

