/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.util.AndroidApiLevel;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.codec.LongCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AndroidApiLevelCodec
implements StringCodec<AndroidApiLevel> {
    @Nonnull
    private final LongCodec releasedCodec = new LongCodec();
    @CheckForNull
    private EnumCodec<AndroidApiLevel.ProvisionalLevel> provisionalCodec = new EnumCodec<AndroidApiLevel.ProvisionalLevel>(AndroidApiLevel.ProvisionalLevel.class);

    public AndroidApiLevelCodec() {
        this.releasedCodec.setMin(1L);
        this.provisionalCodec.ignoreCase();
    }

    public void setMinReleasedApiLevel(@Nonnegative int level) {
        this.releasedCodec.setMin(level);
        this.forbidProvisionalLevel();
    }

    public void setMinReleasedApiLevel(@Nonnull AndroidApiLevel.ReleasedLevel level) {
        this.setMinReleasedApiLevel(level.getLevel());
    }

    public void setMaxReleasedApiLevel(@Nonnegative int level) {
        this.releasedCodec.setMax(level);
        this.forbidProvisionalLevel();
    }

    public void setMaxReleasedApiLevel(@Nonnull AndroidApiLevel.ReleasedLevel level) {
        this.setMinReleasedApiLevel(level.getLevel());
    }

    public void forbidProvisionalLevel() {
        this.provisionalCodec = null;
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "level";
    }

    @Override
    @Nonnull
    public AndroidApiLevel parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public AndroidApiLevel checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            return new AndroidApiLevel(this.releasedCodec.checkString(context, string).intValue());
        }
        catch (ParsingException e1) {
            if (this.provisionalCodec != null) {
                try {
                    return new AndroidApiLevel((AndroidApiLevel.ProvisionalLevel)((Object)this.provisionalCodec.checkString(context, string)));
                }
                catch (ParsingException e2) {
                    throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
                }
            }
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
    }

    @Override
    @Nonnull
    public String getUsage() {
        String usage = "a released API level as " + this.releasedCodec.getUsage();
        if (this.provisionalCodec != null && this.provisionalCodec.hasPublicEntries()) {
            usage = usage + " or a provisional API level as " + this.provisionalCodec.getUsage();
        }
        return usage;
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        ArrayList<Parser.ValueDescription> descriptions = new ArrayList<Parser.ValueDescription>();
        descriptions.addAll(this.releasedCodec.getValueDescriptions());
        if (this.provisionalCodec != null) {
            descriptions.addAll(this.provisionalCodec.getValueDescriptions());
        }
        return descriptions;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull AndroidApiLevel data) {
        if (data.isReleasedLevel()) {
            return this.releasedCodec.formatValue(Long.valueOf(data.getReleasedLevel()));
        }
        assert (this.provisionalCodec != null);
        return this.provisionalCodec.formatValue(data.getProvisionalLevel());
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull AndroidApiLevel data) throws CheckingException {
        if (data.isReleasedLevel()) {
            this.releasedCodec.checkValue(context, Long.valueOf(data.getReleasedLevel()));
            return;
        }
        if (this.provisionalCodec == null) {
            throw new CheckingException("Provisional API level not allowed");
        }
        this.provisionalCodec.checkValue(context, data.getProvisionalLevel());
    }
}

