/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JNameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class AnnotationUtils {
    @Nonnull
    public static Set<JAnnotationType> getAnnotationTypes(@Nonnull Collection<JAnnotation> annotations) {
        HashSet<JAnnotationType> annotationTypes = new HashSet<JAnnotationType>();
        for (JAnnotation annotation : annotations) {
            annotationTypes.add(annotation.getType());
        }
        return annotationTypes;
    }

    @Nonnull
    public static List<JAnnotation> getAnnotation(@Nonnull Collection<JAnnotation> annotations, @Nonnull JAnnotationType annotationType) {
        ArrayList<JAnnotation> foundAnnotations = new ArrayList<JAnnotation>();
        for (JAnnotation annotation : annotations) {
            if (!annotation.getType().equals(annotationType)) continue;
            foundAnnotations.add(annotation);
        }
        return foundAnnotations;
    }

    public static boolean getBooleanValueFromAnnotation(@Nonnull JAnnotation annotation, @Nonnull String name, boolean defaultValue) {
        boolean value = defaultValue;
        JNameValuePair removeAfterValuePair = annotation.getNameValuePair(name);
        if (removeAfterValuePair != null && removeAfterValuePair.getValue() instanceof JBooleanLiteral) {
            value = ((JBooleanLiteral)removeAfterValuePair.getValue()).getValue();
        }
        return value;
    }
}

