/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import java.io.PrintWriter;
import javax.annotation.Nonnull;

public class StructurePrinter
extends JVisitor {
    @Nonnull
    private static final TypeAndMethodFormatter formatter = BinarySignatureFormatter.getFormatter();
    @Nonnull
    private final PrintWriter writer;

    public StructurePrinter(@Nonnull PrintWriter out) {
        this.writer = out;
    }

    @Override
    public boolean visit(@Nonnull JDefinedClassOrInterface type) {
        if (this.acceptFilter(type)) {
            this.writer.print(formatter.getName(type));
            this.writer.println(":");
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JField field) {
        if (this.acceptFilter(field)) {
            this.writer.print(formatter.getName(field.getType()));
            this.writer.print(" ");
            this.writer.println(field.getName());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethod method) {
        if (this.acceptFilter(method)) {
            this.writer.println(formatter.getName(method));
        }
        return false;
    }

    protected boolean acceptFilter(@Nonnull JDefinedClassOrInterface type) {
        return this.acceptFilter((JNode)type);
    }

    protected boolean acceptFilter(@Nonnull JField field) {
        return this.acceptFilter((JNode)field);
    }

    protected boolean acceptFilter(@Nonnull JMethod method) {
        return this.acceptFilter((JNode)method);
    }

    protected boolean acceptFilter(@Nonnull JNode node) {
        return true;
    }
}

