/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util.graph;

import com.android.jack.util.graph.Graph;
import com.android.jack.util.graph.GraphNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class GraphUtils {
    @Nonnull
    public static <T extends GraphNode<T>> List<T> getNodesInPostOrder(@Nonnull Graph<T> graph) {
        int nodesCount = graph.getNodes().size();
        ArrayList<GraphNode> resultList = new ArrayList<GraphNode>(nodesCount);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(graph.getEntryNode());
        while (!stack.isEmpty()) {
            GraphNode node = (GraphNode)stack.peekFirst();
            assert (node != null);
            GraphNode nextSuccessor = null;
            for (GraphNode succ : node.getSuccessors()) {
                if (succ == graph.getExitNode() || stack.contains(succ) || resultList.contains(succ)) continue;
                nextSuccessor = succ;
                break;
            }
            if (nextSuccessor != null) {
                stack.addFirst(nextSuccessor);
                continue;
            }
            if (node != graph.getEntryNode() && node != graph.getExitNode()) {
                resultList.add(node);
            }
            stack.removeFirst();
        }
        assert (resultList.size() == nodesCount);
        return resultList;
    }
}

