/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.api.example;

import com.android.jill.api.ConfigNotSupportedException;
import com.android.jill.api.JillConfig;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01Config;
import com.android.jill.api.v01.Api01TranslationTask;
import com.android.jill.api.v01.ConfigurationException;
import com.android.jill.api.v01.TranslationException;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public class WithServiceLoader {
    public static void main(String[] args) throws SecurityException, IllegalArgumentException {
        Api01TranslationTask translationTask;
        Api01Config api01Config;
        JillProvider provider;
        if (args.length != 2) {
            System.out.println("Usage: <jill input archive> <jill output archive>");
            return;
        }
        ServiceLoader<JillProvider> serviceLoader = ServiceLoader.load(JillProvider.class);
        try {
            provider = serviceLoader.iterator().next();
        }
        catch (NoSuchElementException e) {
            System.out.println("Check that jill.jar is on classpath");
            return;
        }
        System.out.println("Translator version: " + provider.getTranslatorVersion());
        System.out.println("Translator release name: " + provider.getTranslatorReleaseName());
        System.out.println("Translator release code: " + provider.getTranslatorReleaseCode());
        System.out.println("Translator sub-release kind: " + (Object)((Object)provider.getTranslatorSubReleaseKind()));
        System.out.println("Translator sub-release code: " + provider.getTranslatorSubReleaseCode());
        String str = provider.getTranslatorBuildId();
        System.out.println("Translator build id: " + (str != null ? str : "Unknown"));
        str = provider.getTranslatorSourceCodeBase();
        System.out.println("Translator souce code base: " + (str != null ? str : "Unknown"));
        System.out.print("Supported configurations: ");
        for (Class<? extends JillConfig> clazz : provider.getSupportedConfigs()) {
            System.out.print(clazz.getSimpleName());
            assert (provider.isConfigSupported(clazz));
        }
        System.out.println();
        try {
            api01Config = provider.createConfig(Api01Config.class);
        }
        catch (ConfigNotSupportedException e1) {
            System.err.println("Brest config not supported)");
            return;
        }
        try {
            api01Config.setInputJavaBinaryFile(new File(args[0]));
            api01Config.setOutputJackFile(new File(args[1]));
            translationTask = api01Config.getTask();
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage());
            return;
        }
        try {
            translationTask.run();
        }
        catch (TranslationException e) {
            System.out.println("User error, see reporter");
            return;
        }
    }
}

