/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util;

import com.android.jack.google.common.collect.Iterators;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.NoLocation;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.LocationByteStreamSucker;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class VFSClassLoader
extends ClassLoader {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    @Nonnull
    protected final InputVFS vfs;

    public VFSClassLoader(@Nonnull InputVFS vfs, @CheckForNull ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.vfs = vfs;
    }

    @Override
    @CheckForNull
    public InputStream getResourceAsStream(@Nonnull String name) {
        VPath path = new VPath(name, '/');
        try {
            InputVFile vFile = this.vfs.getRootDir().getInputVFile(path);
            return vFile.getInputStream();
        }
        catch (WrongPermissionException e) {
            logger.log(Level.INFO, "Failed to open resource '" + name + "' from " + this.vfs.getLocation().getDescription(), e);
            return null;
        }
        catch (NoSuchFileException | NotFileOrDirectoryException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    protected Class<?> findClass(@Nonnull String name) throws ClassNotFoundException {
        InputVFile vFile;
        VPath path = new VPath(name, '.');
        path.addSuffix(".class");
        try {
            vFile = this.vfs.getRootDir().getInputVFile(path);
        }
        catch (NoSuchFileException | NotFileOrDirectoryException e) {
            throw new ClassNotFoundException(name, e);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            try (InputStream is = vFile.getInputStream();){
                new LocationByteStreamSucker(is, (OutputStream)byteStream, vFile.getLocation(), NoLocation.getInstance()).suck();
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)vFile, (Exception)e);
            }
        }
        catch (CannotWriteException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCloseException | CannotReadException e) {
            logger.log(Level.SEVERE, "Failed to load class '" + name + "' from " + this.vfs.getLocation().getDescription(), e);
            throw new ClassNotFoundException(name, e);
        }
        catch (WrongPermissionException e) {
            logger.log(Level.INFO, "Failed to load class '" + name + "' from " + this.vfs.getLocation().getDescription(), e);
            throw new ClassNotFoundException(name, e);
        }
        byte[] byteArray = byteStream.toByteArray();
        return this.defineClass(name, byteArray, 0, byteArray.length);
    }

    @Override
    @CheckForNull
    protected URL findResource(@Nonnull String name) {
        VPath path = new VPath(name, '/');
        try {
            InputVFile vFile = this.vfs.getRootDir().getInputVFile(path);
            try {
                return new URL("jack-vfs", "", -1, this.vfs.getPath().replace(File.separatorChar, '/') + "/" + vFile.getPathFromRoot().getPathAsString('/'), new VFSURLHandler(vFile));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        catch (NoSuchFileException | NotFileOrDirectoryException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL resource = this.findResource(name);
        return Iterators.asEnumeration(resource != null ? Iterators.singletonIterator(resource) : Collections.emptyIterator());
    }

    private static class VFSURLConnection
    extends URLConnection {
        @Nonnull
        private final InputVFile vFile;
        @CheckForNull
        private InputStream is;

        private VFSURLConnection(@Nonnull URL url, @Nonnull InputVFile vFile) {
            super(url);
            this.vFile = vFile;
        }

        @Override
        public synchronized void connect() throws IOException {
            if (!this.connected) {
                assert (this.is == null);
                try {
                    this.is = this.vFile.getInputStream();
                }
                catch (WrongPermissionException e) {
                    throw new IOException(e);
                }
                this.connected = true;
            }
        }

        @Override
        @Nonnull
        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
        public InputStream getInputStream() throws IOException {
            this.connect();
            assert (this.is != null);
            return this.is;
        }
    }

    private static class VFSURLHandler
    extends URLStreamHandler {
        @Nonnull
        private final InputVFile vFile;

        private VFSURLHandler(@Nonnull InputVFile vFile) {
            this.vFile = vFile;
        }

        @Override
        protected URLConnection openConnection(URL u) {
            return new VFSURLConnection(u, this.vFile);
        }
    }
}

