/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.DirectFSCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.vfs.GenericOutputVFS;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.VFS;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DirectDirOutputVFSCodec
implements StringCodec<OutputVFS> {
    private final DirectFSCodec directFSCodec;

    public DirectDirOutputVFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        this.directFSCodec = new DirectFSCodec(existence).withoutCache();
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to an output directory (" + this.directFSCodec.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.directFSCodec.getVariableName();
    }

    @Override
    @Nonnull
    public OutputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        VFS vfs = this.directFSCodec.checkString(context, string);
        return new GenericOutputVFS(vfs);
    }

    @Override
    @Nonnull
    public OutputVFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Nonnull
    public DirectDirOutputVFSCodec setInfoString(@CheckForNull String infoString) {
        this.directFSCodec.setInfoString(infoString);
        return this;
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.directFSCodec.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull OutputVFS data) {
        return this.directFSCodec.formatValue(data.getVFS());
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull OutputVFS data) {
        this.directFSCodec.checkValue(context, data.getVFS());
    }
}

