/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill;

import com.android.jill.JillException;
import com.android.jill.Options;
import com.android.jill.frontend.java.JavaTransformer;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.utils.FileUtils;
import com.android.sched.util.Version;
import com.android.sched.util.file.CannotListDirException;
import com.android.sched.util.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class Jill {
    @CheckForNull
    private static Version version = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void process(@Nonnull Options options) {
        File binaryFile = options.getBinaryFile();
        JavaTransformer jt = new JavaTransformer(Jill.getVersion().getVersion(), options);
        if (binaryFile.isFile()) {
            if (FileUtils.isJavaBinaryFile(binaryFile)) {
                ArrayList<File> javaBinaryFiles = new ArrayList<File>();
                javaBinaryFiles.add(binaryFile);
                jt.transform(javaBinaryFiles);
                return;
            }
            if (!FileUtils.isJarFile(binaryFile)) throw new JillException("Unsupported file type: " + binaryFile.getName());
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(binaryFile);
                jt.transform(jarFile);
                return;
            }
            catch (IOException e) {
                throw new JillException("Failed to create jar file " + binaryFile.getName(), e);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger().log(Level.WARNING, "Failed to close jar file " + binaryFile.getName());
                    }
                }
            }
        }
        ArrayList<File> javaBinaryFiles = new ArrayList<File>();
        try {
            FileUtils.getJavaBinaryFiles(binaryFile, javaBinaryFiles);
        }
        catch (CannotListDirException e) {
            throw new JillException(e);
        }
        jt.transform(javaBinaryFiles);
    }

    @Nonnull
    public static Version getVersion() {
        if (version == null) {
            try {
                version = new Version("jill", Jill.class.getClassLoader());
            }
            catch (IOException e) {
                System.err.println("Failed to read version properties file: " + e.getMessage());
                throw new AssertionError();
            }
        }
        assert (version != null);
        return version;
    }
}

