/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.api.impl;

import com.android.jill.Jill;
import com.android.jill.api.ConfigNotSupportedException;
import com.android.jill.api.JillConfig;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01Config;
import com.android.jill.api.v01.Cli01Config;
import com.android.jill.api.v01.impl.Api01ConfigImpl;
import com.android.jill.api.v01.impl.Cli01ConfigImpl;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;

public class JillProviderImpl
implements JillProvider {
    @Override
    @Nonnull
    public <T extends JillConfig> T createConfig(@Nonnull Class<T> cls) throws ConfigNotSupportedException {
        if (cls == Api01Config.class) {
            return (T)new Api01ConfigImpl();
        }
        if (cls == Cli01Config.class) {
            return (T)new Cli01ConfigImpl();
        }
        throw new ConfigNotSupportedException(cls.getName() + " are not supported");
    }

    @Override
    @Nonnull
    public <T extends JillConfig> boolean isConfigSupported(@Nonnull Class<T> cls) {
        return cls == Api01Config.class || cls == Cli01Config.class;
    }

    @Override
    @Nonnull
    public Collection<Class<? extends JillConfig>> getSupportedConfigs() {
        ArrayList<Class<? extends JillConfig>> result = new ArrayList<Class<? extends JillConfig>>(2);
        result.add(Api01Config.class);
        result.add(Cli01Config.class);
        return result;
    }

    @Override
    @Nonnull
    public String getTranslatorVersion() {
        return Jill.getVersion().getVersion();
    }

    @Override
    @Nonnull
    public String getTranslatorReleaseName() {
        return Jill.getVersion().getReleaseName();
    }

    @Override
    public int getTranslatorReleaseCode() {
        return Jill.getVersion().getReleaseCode();
    }

    @Override
    public int getTranslatorSubReleaseCode() {
        return Jill.getVersion().getSubReleaseCode();
    }

    @Override
    @Nonnull
    public JillProvider.SubReleaseKind getTranslatorSubReleaseKind() {
        switch (Jill.getVersion().getSubReleaseKind()) {
            case ENGINEERING: {
                return JillProvider.SubReleaseKind.ENGINEERING;
            }
            case PRE_ALPHA: {
                return JillProvider.SubReleaseKind.PRE_ALPHA;
            }
            case ALPHA: {
                return JillProvider.SubReleaseKind.ALPHA;
            }
            case BETA: {
                return JillProvider.SubReleaseKind.BETA;
            }
            case CANDIDATE: {
                return JillProvider.SubReleaseKind.CANDIDATE;
            }
            case RELEASE: {
                return JillProvider.SubReleaseKind.RELEASE;
            }
        }
        throw new AssertionError((Object)Jill.getVersion().getSubReleaseKind().name());
    }

    @Override
    @CheckForNull
    public String getTranslatorBuildId() {
        return Jill.getVersion().getBuildId();
    }

    @Override
    @CheckForNull
    public String getTranslatorSourceCodeBase() {
        return Jill.getVersion().getCodeBase();
    }
}

