/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.backend.jayce;

import com.android.jill.javax.annotation.Nonnull;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class JayceOutputStream
implements DataOutput {
    @Nonnull
    private final DataOutputStream out;

    public JayceOutputStream(@Nonnull OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    @Nonnull
    private static byte[] stringToUtf8Bytes(@Nonnull String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                bytes[outAt] = (byte)c;
                ++outAt;
                continue;
            }
            if (c < '\u0800') {
                bytes[outAt] = (byte)(c >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        int end;
        int remaining = v >> 7;
        boolean hasMore = true;
        int n = end = (v & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (v >> 6 & 1);
            this.writeByte((byte)(v & 0x7F | (hasMore ? 128 : 0)));
            v = remaining;
            remaining >>= 7;
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        long end;
        long remaining = v >> 7;
        boolean hasMore = true;
        long l = end = (v & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (v >> 6 & 1L);
            this.writeByte((byte)(v & 0x7FL | (long)(hasMore ? 128 : 0)));
            v = remaining;
            remaining >>= 7;
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            byte[] utf8String = JayceOutputStream.stringToUtf8Bytes(s);
            this.writeInt(utf8String.length);
            this.write(utf8String);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

