/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.backend.jayce;

import com.android.jill.backend.jayce.JayceOutputStream;
import com.android.jill.backend.jayce.Token;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.utils.enums.DispatchKindIdHelper;
import com.android.jill.utils.enums.FieldRefKindIdHelper;
import com.android.jill.utils.enums.MethodKindIdHelper;
import com.android.jill.utils.enums.ReceiverKindIdHelper;
import com.android.jill.utils.enums.RetentionPolicyIdHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class JayceWriter {
    protected final Stack<JayceOutputStream> writers = new Stack();
    private final Stack<ByteArrayOutputStream> outputStreams = new Stack();
    private final Stack<Integer> nodeCounters = new Stack();
    @Nonnull
    private final List<String> currentCatchBlockList = new ArrayList<String>();

    public JayceWriter(@Nonnull OutputStream out) {
        this.writers.push(new JayceOutputStream(out));
        this.nodeCounters.push(0);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writers.peek().writeBoolean(value);
    }

    private void writeIntInternal(int value) throws IOException {
        this.writers.peek().writeInt(value);
    }

    public void writeInt(int value) throws IOException {
        this.writeIntInternal(value);
        this.writeSpace();
    }

    public void writeTrimmedInt(int value) throws IOException {
        this.writeIntInternal(value);
    }

    private void writeLongInternal(long value) throws IOException {
        this.writers.peek().writeLong(value);
    }

    public void writeLong(long value) throws IOException {
        this.writeLongInternal(value);
        this.writeSpace();
    }

    public void writeByte(byte value) throws IOException {
        this.writers.peek().writeByte(value);
        this.writeSpace();
    }

    public void writeShort(short value) throws IOException {
        this.writers.peek().writeShort(value);
        this.writeSpace();
    }

    public void writeChar(char value) throws IOException {
        this.writers.peek().writeChar(value);
        this.writeSpace();
    }

    public void writeFloat(float value) throws IOException {
        this.writeIntInternal(Float.floatToRawIntBits(value));
        this.writeSpace();
    }

    public void writeDouble(double value) throws IOException {
        this.writeLongInternal(Double.doubleToRawLongBits(value));
        this.writeSpace();
    }

    public void writeKeyword(@Nonnull Token token) throws IOException {
        this.writers.peek().writeByte(token.ordinal());
        this.nodeCounters.push(this.nodeCounters.pop() + 1);
    }

    public void writeToken(@Nonnull Token token) throws IOException {
        this.writers.peek().writeByte(token.ordinal());
    }

    public void writeOpen() throws IOException {
        this.nodeCounters.push(0);
    }

    public void writeClose() throws IOException {
        this.writeToken(Token.RPARENTHESIS);
        this.nodeCounters.pop();
    }

    public void writeOpenNodeList() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.outputStreams.push(baos);
        this.writers.push(new JayceOutputStream(baos));
        this.nodeCounters.push(0);
    }

    public void writeCloseNodeList() throws IOException {
        JayceOutputStream w = this.writers.pop();
        w.flush();
        ByteArrayOutputStream baos = this.outputStreams.pop();
        this.writeIntInternal(this.nodeCounters.pop());
        this.writers.peek().write(baos.toByteArray());
        w.close();
        this.writeToken(Token.RPARENTHESIS);
    }

    public void writeRetentionPolicyEnum(@Nonnull Enum<?> enumValue) throws IOException {
        this.writeByte(RetentionPolicyIdHelper.getId(enumValue));
    }

    public void writeFieldRefKindEnum(@Nonnull Enum<?> enumValue) throws IOException {
        this.writeByte(FieldRefKindIdHelper.getId(enumValue));
    }

    public void writeMethodKindEnum(@Nonnull Enum<?> enumValue) throws IOException {
        this.writeByte(MethodKindIdHelper.getId(enumValue));
    }

    public void writeReceiverKindEnum(@Nonnull Enum<?> enumValue) throws IOException {
        this.writeByte(ReceiverKindIdHelper.getId(enumValue));
    }

    public void writeDispatchKindEnum(@Nonnull Enum<?> enumValue) throws IOException {
        this.writeByte(DispatchKindIdHelper.getId(enumValue));
    }

    public void writeIds(@Nonnull List<String> list) throws IOException {
        this.writeOpen();
        this.writeIntInternal(list.size());
        for (String id : list) {
            this.writeId(id);
        }
        this.writeClose();
    }

    public void writeCatchBlockIds(@Nonnull Set<String> list) throws IOException {
        int i;
        ArrayList<String> removedIds = new ArrayList<String>(this.currentCatchBlockList.size());
        ArrayList<String> addedIds = new ArrayList<String>(list.size());
        for (String s : this.currentCatchBlockList) {
            removedIds.add(s);
        }
        for (String s : list) {
            addedIds.add(s);
        }
        this.currentCatchBlockList.retainAll(list);
        removedIds.removeAll(this.currentCatchBlockList);
        addedIds.removeAll(this.currentCatchBlockList);
        int addedIdsSize = addedIds.size();
        int removedIdsSize = removedIds.size();
        if (addedIdsSize > 0) {
            this.writeOpenAddCatchBlockIds();
            this.writeTrimmedInt(addedIdsSize);
            for (i = 0; i < addedIdsSize; ++i) {
                this.writeString((String)addedIds.get(i));
            }
            this.writeCloseCatchBlockIds();
        }
        if (removedIdsSize > 0) {
            this.writeOpenRemoveCatchBlockIds();
            this.writeTrimmedInt(removedIdsSize);
            for (i = 0; i < removedIdsSize; ++i) {
                this.writeString((String)removedIds.get(i));
            }
            this.writeCloseCatchBlockIds();
        }
        this.currentCatchBlockList.addAll(addedIds);
    }

    public void clearCatchBlockIds() {
        this.currentCatchBlockList.clear();
    }

    public boolean isCurrentCatchBlockListEmpty() {
        return this.currentCatchBlockList.isEmpty();
    }

    public void writeId(@CheckForNull String id) throws IOException {
        this.writeStringInternal(id);
    }

    private void writeStringInternal(@CheckForNull String string) throws IOException {
        this.writers.peek().writeUTF(string);
    }

    public void writeString(@CheckForNull String string) throws IOException {
        this.writeStringInternal(string);
    }

    public void writeNull() throws IOException {
        this.writeToken(Token.NULL);
        this.writeSpace();
        this.nodeCounters.push(this.nodeCounters.pop() + 1);
    }

    protected void writeSpace() throws IOException {
    }

    public void writeFileName(@CheckForNull String fileName) throws IOException {
        this.writeOpenFileName();
        this.writeStringInternal(fileName);
        this.writeCloseFileName();
    }

    private void writeOpenFileName() throws IOException {
        this.writeToken(Token.SHARP);
    }

    private void writeCloseFileName() throws IOException {
    }

    public void writeCurrentLineInfo(int lineNumber) throws IOException {
        this.writeOpenLineInfo();
        this.writeIntInternal(lineNumber);
        this.writeCloseLineInfo();
    }

    private void writeOpenLineInfo() throws IOException {
        this.writeToken(Token.LBRACKET);
    }

    private void writeCloseLineInfo() throws IOException {
    }

    private void writeOpenAddCatchBlockIds() throws IOException {
        this.writeToken(Token.LCURLY_ADD);
    }

    private void writeOpenRemoveCatchBlockIds() throws IOException {
        this.writeToken(Token.LCURLY_REMOVE);
    }

    private void writeCloseCatchBlockIds() throws IOException {
    }

    public void flush() throws IOException {
        this.writers.peek().flush();
    }
}

