/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jill.JillException;
import com.android.jill.Options;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.backend.jayce.Token;
import com.android.jill.frontend.java.AnnotationWriter;
import com.android.jill.frontend.java.AsmHelper;
import com.android.jill.frontend.java.JillWriter;
import com.android.jill.frontend.java.SourceInfoWriter;
import com.android.jill.frontend.java.Variable;
import com.android.jill.frontend.java.analyzer.JillAnalyzer;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.objectweb.asm.Handle;
import com.android.jill.objectweb.asm.Opcodes;
import com.android.jill.objectweb.asm.Type;
import com.android.jill.objectweb.asm.commons.JSRInlinerAdapter;
import com.android.jill.objectweb.asm.tree.AbstractInsnNode;
import com.android.jill.objectweb.asm.tree.ClassNode;
import com.android.jill.objectweb.asm.tree.FieldInsnNode;
import com.android.jill.objectweb.asm.tree.FrameNode;
import com.android.jill.objectweb.asm.tree.IincInsnNode;
import com.android.jill.objectweb.asm.tree.InsnNode;
import com.android.jill.objectweb.asm.tree.IntInsnNode;
import com.android.jill.objectweb.asm.tree.InvokeDynamicInsnNode;
import com.android.jill.objectweb.asm.tree.JumpInsnNode;
import com.android.jill.objectweb.asm.tree.LabelNode;
import com.android.jill.objectweb.asm.tree.LdcInsnNode;
import com.android.jill.objectweb.asm.tree.LineNumberNode;
import com.android.jill.objectweb.asm.tree.LocalVariableNode;
import com.android.jill.objectweb.asm.tree.LookupSwitchInsnNode;
import com.android.jill.objectweb.asm.tree.MethodInsnNode;
import com.android.jill.objectweb.asm.tree.MethodNode;
import com.android.jill.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.android.jill.objectweb.asm.tree.TableSwitchInsnNode;
import com.android.jill.objectweb.asm.tree.TryCatchBlockNode;
import com.android.jill.objectweb.asm.tree.TypeInsnNode;
import com.android.jill.objectweb.asm.tree.VarInsnNode;
import com.android.jill.objectweb.asm.tree.analysis.Analyzer;
import com.android.jill.objectweb.asm.tree.analysis.AnalyzerException;
import com.android.jill.objectweb.asm.tree.analysis.BasicValue;
import com.android.jill.objectweb.asm.tree.analysis.Frame;
import com.android.jill.objectweb.asm.util.Printer;
import com.android.jill.objectweb.asm.util.Textifier;
import com.android.jill.objectweb.asm.util.TraceMethodVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MethodBodyWriter
extends JillWriter
implements Opcodes {
    @Nonnull
    private static final String LAMBDA_META_FACTORY = "java/lang/invoke/LambdaMetafactory";
    @Nonnull
    private static final String ALT_META_FACTORY = "altMetafactory";
    @Nonnull
    private static final String META_FACTORY = "metafactory";
    @Nonnegative
    private static final int LAMBDA_FLAG_SERIALIZABLE = 1;
    @Nonnegative
    private static final int LAMBDA_FLAG_MARKERS = 2;
    @Nonnegative
    private static final int LAMBDA_FLAG_BRDIGES = 4;
    @Nonnull
    private static final String JAVA_IO_SERIALIZABLE = "Ljava/io/Serializable;";
    @Nonnull
    private static final String LAMBDA_MTH_PREFIX = "lambda$";
    @Nonnegative
    public static final int LAMBDA_METHOD = 0x200000;
    @Nonnegative
    public static final int NAME_PRESENT = 0x400000;
    @Nonnull
    private final Map<String, Variable> nameToVar = new HashMap<String, Variable>();
    @Nonnull
    private final Map<Variable, Variable> parameter2Var = new LinkedHashMap<Variable, Variable>();
    public static final int CONSTRUCTOR = 65536;
    @Nonnull
    private final HashMap<Variable, CmpOperands> cmpOperands = new HashMap();
    @Nonnull
    private final HashMap<Variable, Object> varWithCstValue = new HashMap();
    @Nonnull
    private final AnnotationWriter annotWriter;
    @Nonnegative
    private static final int NO_MODIFIER = 0;
    private static final int TOP_OF_STACK = -1;
    @Nonnull
    private final Set<String> currentCatchList = new HashSet<String>();
    @Nonnegative
    private int currentLine = 0;
    @Nonnull
    private final ClassNode currentClass;
    @Nonnull
    private final MethodNode currentMethod;
    @Nonnull
    private final Analyzer<BasicValue> analyzer;
    @Nonnegative
    private int unusedVarCount = 0;
    @Nonnegative
    private int currentPc = 0;
    private int startLine = 0;
    private int endLine = 0;
    @Nonnull
    private final Options options;
    private int lambdaCount = 0;
    @Nonnull
    private final Map<TryCatchBlockNode, Variable> catchBlockToCatchedVariable = new HashMap<TryCatchBlockNode, Variable>();
    @Nonnull
    private final List<MethodNode> additionalMethods = new ArrayList<MethodNode>();

    public MethodBodyWriter(@Nonnull JayceWriter writer, @Nonnull AnnotationWriter annotWriter, @Nonnull ClassNode cn, @Nonnull MethodNode mn, @Nonnull SourceInfoWriter sourceInfoWriter, @Nonnull Options options) {
        super(writer, sourceInfoWriter);
        this.annotWriter = annotWriter;
        this.options = options;
        this.currentClass = cn;
        JillAnalyzer bi = new JillAnalyzer();
        this.analyzer = new Analyzer<BasicValue>(bi);
        if (mn.instructions.size() != 0) {
            this.currentMethod = this.getMethodWithoutJSR(mn);
            try {
                this.analyzer.analyze(this.currentClass.name, this.currentMethod);
                this.removeDeadCode();
                this.analyzer.analyze(this.currentClass.name, this.currentMethod);
            }
            catch (AnalyzerException e) {
                throw new JillException("Variable analyser fails.", e);
            }
        } else {
            this.currentMethod = mn;
        }
    }

    @Nonnull
    public List<MethodNode> getAdditionalMethods() {
        return this.additionalMethods;
    }

    public void write() throws IOException {
        if (AsmHelper.isAnnotation(this.currentClass) && AsmHelper.isAbstract(this.currentMethod) && (this.currentMethod.parameters == null || this.currentMethod.parameters.isEmpty())) {
            this.writeAnnotationMethod();
        } else if (AsmHelper.isConstructor(this.currentMethod)) {
            this.writeConstructor();
        } else {
            this.writeMethod();
        }
    }

    private void writeConstructor() throws IOException {
        this.computeStartAndEndLine();
        this.sourceInfoWriter.writeDebugBegin(this.currentClass, this.startLine);
        this.writer.writeKeyword(Token.CONSTRUCTOR);
        this.writer.writeOpen();
        this.writeParameters();
        this.writer.writeInt(AsmHelper.getModifiers(this.currentMethod));
        this.annotWriter.writeAnnotations(this.currentMethod);
        this.writeMethodBody();
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker();
        this.writeThrownExceptionMarker();
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(this.currentClass, this.endLine);
        this.writer.writeClose();
    }

    @Nonnull
    private String updateMethodNameForLambdaIfNeeded(@Nonnull String methodName) {
        if (methodName.startsWith(LAMBDA_MTH_PREFIX)) {
            return this.stringLegalizer(this.currentClass.name) + "_" + methodName;
        }
        return methodName;
    }

    private void writeMethod() throws IOException {
        MethodKind methodKind;
        int modifier;
        this.computeStartAndEndLine();
        this.sourceInfoWriter.writeDebugBegin(this.currentClass, this.startLine);
        this.writer.writeKeyword(Token.METHOD);
        this.writer.writeOpen();
        this.writer.writeString(this.updateMethodNameForLambdaIfNeeded(this.currentMethod.name));
        this.writer.writeId(Type.getReturnType(this.currentMethod.desc).getDescriptor());
        this.writeParameters();
        if (this.currentMethod.name.startsWith(LAMBDA_MTH_PREFIX)) {
            modifier = 0x201000;
            if (AsmHelper.isInterface(this.currentClass)) {
                modifier |= 1;
            }
            if (AsmHelper.isStatic(this.currentMethod)) {
                modifier |= 8;
                methodKind = MethodKind.STATIC;
            } else {
                methodKind = MethodKind.INSTANCE_VIRTUAL;
            }
        } else {
            methodKind = AsmHelper.isStatic(this.currentMethod) ? MethodKind.STATIC : (AsmHelper.isConstructor(this.currentMethod) || AsmHelper.isPrivate(this.currentMethod) ? MethodKind.INSTANCE_NON_VIRTUAL : MethodKind.INSTANCE_VIRTUAL);
            modifier = AsmHelper.getModifiers(this.currentMethod);
            if (AsmHelper.isStaticInit(this.currentMethod)) {
                modifier |= 0x10000;
            }
        }
        this.writer.writeMethodKindEnum(methodKind);
        this.writer.writeInt(modifier);
        this.annotWriter.writeAnnotations(this.currentMethod);
        this.writeMethodBody();
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker();
        this.writeThrownExceptionMarker();
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(this.currentClass, this.endLine);
        this.writer.writeClose();
    }

    private void writeAnnotationMethod() throws IOException {
        this.computeStartAndEndLine();
        this.sourceInfoWriter.writeDebugBegin(this.currentClass, this.startLine);
        this.writer.writeKeyword(Token.ANNOTATION_METHOD);
        this.writer.writeOpen();
        this.writer.writeString(this.currentMethod.name);
        this.writer.writeId(Type.getReturnType(this.currentMethod.desc).getDescriptor());
        this.writer.writeInt(AsmHelper.getModifiers(this.currentMethod));
        this.annotWriter.writeAnnotations(this.currentMethod);
        if (this.currentMethod.annotationDefault != null) {
            this.annotWriter.writeValue(this.currentMethod.annotationDefault);
        } else {
            this.writer.writeNull();
        }
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker();
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(this.currentClass, this.endLine);
        this.writer.writeClose();
    }

    private void writeGenericSignatureMarker() throws IOException {
        if (AsmHelper.hasValidGenericSignature(this.currentMethod)) {
            this.writer.writeKeyword(Token.GENERIC_SIGNATURE);
            this.writer.writeOpen();
            this.writer.writeString(this.currentMethod.signature);
            this.writer.writeClose();
        }
    }

    private void writeThrownExceptionMarker() throws IOException {
        if (this.currentMethod.exceptions != null && !this.currentMethod.exceptions.isEmpty()) {
            this.writer.writeKeyword(Token.THROWN_EXCEPTION);
            this.writer.writeOpen();
            this.writer.writeIds(AsmHelper.getDescriptorsFromInternalNames(this.currentMethod.exceptions));
            this.writer.writeClose();
        }
    }

    @Nonnull
    private MethodNode getMethodWithoutJSR(@Nonnull MethodNode mn) {
        JSRInlinerAdapter jsrInliner = new JSRInlinerAdapter(null, mn.access, mn.name, mn.desc, mn.signature, mn.exceptions.toArray(new String[mn.exceptions.size()]));
        mn.accept(jsrInliner);
        return jsrInliner;
    }

    private void writeMethodBody() throws IOException {
        this.currentCatchList.clear();
        this.writer.clearCatchBlockIds();
        if (AsmHelper.isNative(this.currentMethod)) {
            this.writeNativeMethodBody();
        } else if (AsmHelper.isAbstract(this.currentMethod)) {
            this.writer.writeNull();
        } else {
            this.createCaughtVariables();
            this.currentLine = this.startLine;
            this.writeJavaMethodBody();
        }
        assert (this.writer.isCurrentCatchBlockListEmpty());
    }

    private void computeStartAndEndLine() {
        for (AbstractInsnNode insn : this.currentMethod.instructions.toArray()) {
            if (!(insn instanceof LineNumberNode)) continue;
            LineNumberNode lnn = (LineNumberNode)insn;
            if (this.startLine == 0) {
                this.startLine = lnn.line;
                this.endLine = lnn.line + 1;
                continue;
            }
            if (lnn.line < this.startLine) {
                this.startLine = lnn.line;
                continue;
            }
            if (lnn.line <= this.endLine) continue;
            this.endLine = lnn.line;
        }
    }

    private void createCaughtVariables() {
        for (TryCatchBlockNode tryCatchNode : this.currentMethod.tryCatchBlocks) {
            Variable declaringCatchVariable = null;
            Type caughtType = tryCatchNode.type == null ? Type.getType(Object.class) : Type.getType(Throwable.class);
            String id = "-e_" + this.unusedVarCount++;
            declaringCatchVariable = new Variable(id, id, caughtType);
            this.catchBlockToCatchedVariable.put(tryCatchNode, declaringCatchVariable);
        }
    }

    private void writeNativeMethodBody() throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.NATIVE_METHOD_BODY);
        this.writer.writeOpen();
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    private void writeJavaMethodBody() throws IOException {
        this.sourceInfoWriter.writeDebugBegin(this.currentClass, this.startLine);
        this.writer.writeKeyword(Token.METHOD_BODY);
        this.writer.writeOpen();
        this.writeLocals();
        this.writeBody();
        this.sourceInfoWriter.writeDebugEnd(this.currentClass, this.endLine);
        this.writer.writeClose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeBody() throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.BLOCK);
        this.writer.writeOpen();
        this.writer.writeOpenNodeList();
        if (this.currentMethod.instructions.size() == 0) {
            if (!this.options.isTolerant()) throw new JillException("Method should have instructions.");
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeCatchBlockIds(this.currentCatchList);
            this.writer.writeKeyword(Token.THROW_STATEMENT);
            this.writer.writeOpen();
            this.writer.writeKeyword(Token.NEW_INSTANCE);
            this.writer.writeOpen();
            this.writer.writeId("Ljava/lang/AssertionError;");
            this.writer.writeIds(Collections.emptyList());
            this.writer.writeOpenNodeList();
            this.writer.writeCloseNodeList();
            this.writer.writeClose();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
        } else {
            for (Map.Entry<Variable, Variable> entry : this.parameter2Var.entrySet()) {
                Variable p = entry.getKey();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeLocalRef(entry.getValue());
                if (p.getType() == Type.BOOLEAN_TYPE) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, p, Type.INT_TYPE.getDescriptor());
                } else {
                    this.writeLocalRef(p);
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
            }
            Frame<BasicValue>[] frames = this.analyzer.getFrames();
            for (int insnIdx = 0; insnIdx < this.currentMethod.instructions.size(); ++insnIdx) {
                Frame<BasicValue> nextFrame;
                this.currentPc = insnIdx;
                AbstractInsnNode insn = this.currentMethod.instructions.get(insnIdx);
                Frame<BasicValue> currentFrame = frames[insnIdx];
                Frame<BasicValue> frame = nextFrame = insnIdx < frames.length - 1 ? frames[insnIdx + 1] : null;
                if (insn instanceof JumpInsnNode) {
                    this.forceToUseCstThroughVariable();
                    this.writeInsn(currentFrame, (JumpInsnNode)insn, insnIdx);
                    continue;
                }
                if (insn instanceof LdcInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(nextFrame, (LdcInsnNode)insn);
                    continue;
                }
                if (insn instanceof InsnNode) {
                    this.writeInsn(currentFrame, nextFrame, (InsnNode)insn);
                    continue;
                }
                if (insn instanceof VarInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (VarInsnNode)insn);
                    continue;
                }
                if (insn instanceof LabelNode) {
                    this.forceToUseCstThroughVariable();
                    this.computeCatchList((LabelNode)insn);
                    this.writeCatchBlock((LabelNode)insn, insnIdx, frames);
                    this.writeLabelInsn(insnIdx);
                    continue;
                }
                if (insn instanceof FieldInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (FieldInsnNode)insn);
                    continue;
                }
                if (insn instanceof MethodInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (MethodInsnNode)insn);
                    continue;
                }
                if (insn instanceof LineNumberNode) {
                    this.currentLine = ((LineNumberNode)insn).line;
                    continue;
                }
                if (insn instanceof FrameNode) continue;
                if (insn instanceof TypeInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (TypeInsnNode)insn);
                    continue;
                }
                if (insn instanceof TableSwitchInsnNode) {
                    this.forceToUseCstThroughVariable();
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (TableSwitchInsnNode)insn, insnIdx);
                    continue;
                }
                if (insn instanceof LookupSwitchInsnNode) {
                    this.forceToUseCstThroughVariable();
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (LookupSwitchInsnNode)insn, insnIdx);
                    continue;
                }
                if (insn instanceof IntInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (IntInsnNode)insn);
                    continue;
                }
                if (insn instanceof IincInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (IincInsnNode)insn);
                    continue;
                }
                if (insn instanceof MultiANewArrayInsnNode) {
                    assert (nextFrame != null);
                    this.writeInsn(currentFrame, nextFrame, (MultiANewArrayInsnNode)insn);
                    continue;
                }
                if (!(insn instanceof InvokeDynamicInsnNode)) throw new JillException("Unsupported instruction.");
                InvokeDynamicInsnNode iDyn = (InvokeDynamicInsnNode)insn;
                String handleName = iDyn.bsm.getName();
                if (!iDyn.bsm.getOwner().equals(LAMBDA_META_FACTORY) || !handleName.equals(META_FACTORY) && !handleName.equals(ALT_META_FACTORY)) throw new JillException("Method " + handleName + " in " + iDyn.bsm.getOwner().replace('/', '.') + " is not supported with invoke dynamic");
                this.writeLambda(currentFrame, nextFrame, iDyn);
            }
            if (!this.cmpOperands.isEmpty()) {
                throw new AssertionError((Object)"A comparison has not been followed by an if");
            }
        }
        this.writer.writeCloseNodeList();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void forceToUseCstThroughVariable() throws IOException {
        if (!this.varWithCstValue.isEmpty()) {
            ArrayList<Map.Entry<Variable, Object>> sortedConstants = new ArrayList<Map.Entry<Variable, Object>>(this.varWithCstValue.entrySet());
            Collections.sort(sortedConstants, (o1, o2) -> ((Variable)o1.getKey()).getId().compareTo(((Variable)o2.getKey()).getId()));
            for (Map.Entry entry : sortedConstants) {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeLocalRef((Variable)entry.getKey());
                this.writeValue(entry.getValue(), this.currentClass, this.currentLine);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
            }
            this.varWithCstValue.clear();
        }
    }

    private void writeLambda(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull InvokeDynamicInsnNode iDyn) throws IOException {
        Handle mthImplementingLambda = (Handle)iDyn.bsmArgs[1];
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.LAMBDA);
        this.writer.writeOpen();
        this.writer.writeOpenNodeList();
        Type[] capturedVarTypes = Type.getArgumentTypes(iDyn.desc);
        for (int stackArgIndex = capturedVarTypes.length; stackArgIndex > 0; --stackArgIndex) {
            this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, capturedVarTypes[capturedVarTypes.length - stackArgIndex].getDescriptor(), -stackArgIndex);
        }
        this.writer.writeCloseNodeList();
        if (AsmHelper.isInterface(this.currentClass)) {
            this.writer.writeReceiverKindEnum(MethodCallReceiverKind.INTERFACE);
        } else {
            this.writer.writeReceiverKindEnum(MethodCallReceiverKind.CLASS);
        }
        if (!mthImplementingLambda.getName().contains(LAMBDA_MTH_PREFIX)) {
            mthImplementingLambda = this.generateMethodRef(iDyn, mthImplementingLambda, capturedVarTypes);
        }
        this.writer.writeId(Type.getObjectType(mthImplementingLambda.getOwner()).getDescriptor());
        this.writer.writeString(this.updateMethodNameForLambdaIfNeeded(mthImplementingLambda.getName()));
        Type[] argumentTypes = Type.getArgumentTypes(mthImplementingLambda.getDesc());
        ArrayList<String> argsTypeIds = new ArrayList<String>(argumentTypes.length);
        for (Type argType : argumentTypes) {
            argsTypeIds.add(argType.getDescriptor());
        }
        this.writer.writeIds(argsTypeIds);
        switch (mthImplementingLambda.getTag()) {
            case 6: {
                this.writer.writeMethodKindEnum(MethodKind.STATIC);
                break;
            }
            case 7: {
                this.writer.writeMethodKindEnum(MethodKind.INSTANCE_VIRTUAL);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.writer.writeId(Type.getReturnType(mthImplementingLambda.getDesc()).getDescriptor());
        this.writer.writeId(Type.getReturnType(iDyn.desc).getDescriptor());
        int bridgesCountIdx = this.writeBounds(iDyn, 4);
        this.writeMethodId(iDyn.name, (Type)iDyn.bsmArgs[0]);
        this.writeMethodId(iDyn.name, (Type)iDyn.bsmArgs[2]);
        this.writeBridges(iDyn, bridgesCountIdx);
        this.writer.writeOpen();
        this.writer.writeInt(1);
        this.writer.writeKeyword(Token.LAMBDA_FROM_JILL);
        this.writer.writeOpen();
        this.writer.writeClose();
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    @Nonnegative
    private int writeBounds(@Nonnull InvokeDynamicInsnNode iDyn, @Nonnegative int boundsCountIdx) throws IOException {
        List<String> bounds;
        int bridgesCountIdx = boundsCountIdx;
        if (iDyn.bsmArgs.length > 3) {
            int val = (Integer)iDyn.bsmArgs[3];
            bounds = new ArrayList<String>(this.getBoundsCount(iDyn, boundsCountIdx));
            if ((val & 2) == 2) {
                int boundsCount = (Integer)iDyn.bsmArgs[boundsCountIdx];
                int firstBounds = boundsCountIdx + 1;
                bridgesCountIdx = firstBounds + boundsCount;
                for (int boundIdx = firstBounds; boundIdx < bridgesCountIdx; ++boundIdx) {
                    bounds.add(((Type)iDyn.bsmArgs[boundIdx]).getDescriptor());
                }
            }
            if ((val & 1) == 1) {
                bounds.add(JAVA_IO_SERIALIZABLE);
            }
        } else {
            bounds = Collections.emptyList();
        }
        if (bounds.size() > 0) {
            this.writer.writeIds(bounds);
        } else {
            this.writer.writeOpenNodeList();
            this.writer.writeCloseNodeList();
        }
        return bridgesCountIdx;
    }

    @Nonnegative
    private int getBoundsCount(@Nonnull InvokeDynamicInsnNode iDyn, @Nonnegative int boundsCountIdx) {
        int boundsCount = 0;
        int val = (Integer)iDyn.bsmArgs[3];
        if ((val & 2) == 2) {
            boundsCount = (Integer)iDyn.bsmArgs[boundsCountIdx];
        }
        if ((val & 1) == 1) {
            ++boundsCount;
        }
        return boundsCount;
    }

    private void writeBridges(@Nonnull InvokeDynamicInsnNode iDyn, @Nonnegative int bridgesCountIdx) throws IOException {
        int val;
        if (iDyn.bsmArgs.length > 3 && ((val = ((Integer)iDyn.bsmArgs[3]).intValue()) & 4) == 4) {
            int firstBridge;
            int bridgesCount = (Integer)iDyn.bsmArgs[bridgesCountIdx];
            this.writer.writeOpen();
            this.writer.writeInt(bridgesCount);
            for (int bridgeIdx = firstBridge = bridgesCountIdx + 1; bridgeIdx < firstBridge + bridgesCount; ++bridgeIdx) {
                this.writeMethodId(iDyn.name, (Type)iDyn.bsmArgs[bridgeIdx]);
            }
            this.writer.writeClose();
            return;
        }
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
    }

    @Nonnull
    private Handle generateMethodRef(@Nonnull InvokeDynamicInsnNode iDyn, @Nonnull Handle mthtoCall, @Nonnull Type[] capturedVarTypes) {
        int mthImplementingLambdaTag = mthtoCall.getTag();
        Type returnType = this.getReturnTypeOfMthToGenerate(mthtoCall);
        String mthToGenerate = this.getDescOfMethToGenerate(iDyn, mthtoCall, capturedVarTypes);
        int stackSize = returnType.getSize();
        int localSize = 0;
        MethodNode mn = new MethodNode(4104, this.getNextLambdaMethodName(), mthToGenerate, null, null);
        if (mthImplementingLambdaTag == 8) {
            mn.visitTypeInsn(187, returnType.getInternalName());
            mn.visitInsn(89);
            stackSize += 2;
        }
        if (this.mthRefNeedInstance(mthtoCall)) {
            Type[] argTypeOfMethodToGenerate = Type.getArgumentTypes(mthToGenerate);
            assert (argTypeOfMethodToGenerate.length >= 1);
            Type instanceType = argTypeOfMethodToGenerate[0];
            mn.visitVarInsn(instanceType.getOpcode(21), 0);
            localSize += instanceType.getSize();
            stackSize += instanceType.getSize();
        }
        for (Type argType : Type.getArgumentTypes(mthtoCall.getDesc())) {
            mn.visitVarInsn(argType.getOpcode(21), localSize);
            localSize += argType.getSize();
            stackSize += argType.getSize();
        }
        mn.visitMethodInsn(this.getCallOpcodeFromTag(mthImplementingLambdaTag), mthtoCall.getOwner(), mthtoCall.getName(), mthtoCall.getDesc());
        mn.visitInsn(returnType.getOpcode(172));
        mn.visitMaxs(stackSize, localSize);
        this.additionalMethods.add(mn);
        mthtoCall = new Handle(6, this.currentClass.name, mn.name, mthToGenerate);
        return mthtoCall;
    }

    @Nonnegative
    private int getCallOpcodeFromTag(@Nonnegative int handleTag) {
        switch (handleTag) {
            case 6: {
                return 184;
            }
            case 9: {
                return 185;
            }
            case 7: {
                return 183;
            }
            case 5: {
                return 182;
            }
            case 8: {
                return 183;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private String getDescOfMethToGenerate(@Nonnull InvokeDynamicInsnNode iDyn, @Nonnull Handle mthtoCall, @Nonnull Type[] capturedVarTypes) {
        Type[] argumentTypes = Type.getArgumentTypes(mthtoCall.getDesc());
        Type[] lambdaMethodArgTypes = null;
        int argTypeIdxOfMthToGenerate = 0;
        if (this.mthRefNeedInstance(mthtoCall)) {
            void var7_10;
            lambdaMethodArgTypes = new Type[argumentTypes.length + 1];
            Object var7_7 = null;
            if (capturedVarTypes.length != 0) {
                assert (capturedVarTypes.length == 1);
                Type type = capturedVarTypes[0];
            } else {
                Type[] typeOfInterfaceMth = Type.getArgumentTypes(((Type)iDyn.bsmArgs[2]).getDescriptor());
                Type type = typeOfInterfaceMth[0];
            }
            lambdaMethodArgTypes[argTypeIdxOfMthToGenerate++] = var7_10;
        } else {
            lambdaMethodArgTypes = new Type[argumentTypes.length];
        }
        for (Type argType : argumentTypes) {
            lambdaMethodArgTypes[argTypeIdxOfMthToGenerate++] = argType;
        }
        String string = Type.getMethodDescriptor(this.getReturnTypeOfMthToGenerate(mthtoCall), lambdaMethodArgTypes);
        return string;
    }

    @Nonnull
    private Type getReturnTypeOfMthToGenerate(@Nonnull Handle mthtoCall) {
        Type returnType = Type.getReturnType(mthtoCall.getDesc());
        if (mthtoCall.getTag() == 8) {
            returnType = Type.getObjectType(mthtoCall.getOwner());
        }
        return returnType;
    }

    private boolean mthRefNeedInstance(@Nonnull Handle mthtoCall) {
        return mthtoCall.getTag() == 7 || mthtoCall.getTag() == 9 || mthtoCall.getTag() == 5;
    }

    @Nonnull
    private String getNextLambdaMethodName() {
        String lambdaMethodName = this.stringLegalizer(this.currentClass.name) + "_mthref$" + this.lambdaCount;
        while (this.methodNameExist(this.currentClass, lambdaMethodName)) {
            ++this.lambdaCount;
            lambdaMethodName = this.stringLegalizer(this.currentClass.name) + "_mthref$" + this.lambdaCount;
        }
        ++this.lambdaCount;
        return lambdaMethodName;
    }

    private boolean methodNameExist(@Nonnull ClassNode cn, @Nonnull String newMethodName) {
        for (MethodNode mn : this.currentClass.methods) {
            if (!mn.name.equals(newMethodName)) continue;
            return true;
        }
        return false;
    }

    private void writeMethodId(@Nonnull String methodName, @Nonnull Type type) throws IOException {
        this.writer.writeKeyword(Token.METHODID_WITH_RETURN_TYPE);
        this.writer.writeOpen();
        this.writer.writeString(methodName);
        this.writer.writeMethodKindEnum(MethodKind.INSTANCE_VIRTUAL);
        this.writer.writeId(type.getReturnType().getDescriptor());
        Type[] argumentTypes = type.getArgumentTypes();
        ArrayList<String> argsTypeIds = new ArrayList<String>(argumentTypes.length);
        for (Type argType : argumentTypes) {
            argsTypeIds.add(argType.getDescriptor());
        }
        this.writer.writeIds(argsTypeIds);
        this.writer.writeClose();
    }

    private void writeCatchBlock(@Nonnull LabelNode labelNode, @Nonnegative int labelIdx, @Nonnull Frame<BasicValue>[] frames) throws IOException {
        for (TryCatchBlockNode tryCatchNode : this.currentMethod.tryCatchBlocks) {
            if (tryCatchNode.handler != labelNode) continue;
            Variable declaringCatchVariable = this.catchBlockToCatchedVariable.get(tryCatchNode);
            for (AbstractInsnNode insnIntoCatch = tryCatchNode.handler.getNext(); insnIntoCatch != null && insnIntoCatch.getOpcode() == -1; insnIntoCatch = insnIntoCatch.getNext()) {
                if (!(insnIntoCatch instanceof LineNumberNode)) continue;
                this.currentLine = ((LineNumberNode)insnIntoCatch).line;
            }
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeCatchBlockIds(this.currentCatchList);
            this.writer.writeKeyword(Token.CATCH_BLOCK);
            this.writer.writeOpen();
            this.writer.writeId(this.getCatchId(tryCatchNode.handler));
            ArrayList<String> ids = new ArrayList<String>();
            if (tryCatchNode.type == null) {
                ids.add(Type.getType(Object.class).getDescriptor());
            } else {
                ids.add(Type.getObjectType(tryCatchNode.type).getDescriptor());
                for (TryCatchBlockNode tryCatchNode2 : this.currentMethod.tryCatchBlocks) {
                    if (labelNode != tryCatchNode2.handler || tryCatchNode == tryCatchNode2 || tryCatchNode.type.equals(tryCatchNode2.type)) continue;
                    ids.add(Type.getObjectType(tryCatchNode2.type).getDescriptor());
                }
            }
            this.writer.writeIds(ids);
            this.writeLocal(declaringCatchVariable);
            this.writer.writeOpenNodeList();
            if (frames[labelIdx] != null) {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(frames[labelIdx], -1);
                this.writeLocalRef(declaringCatchVariable);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
            }
            this.writeGoto(tryCatchNode.handler);
            this.writer.writeCloseNodeList();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
            break;
        }
    }

    private void computeCatchList(@Nonnull LabelNode labelNode) {
        for (TryCatchBlockNode tryCatchNode : this.currentMethod.tryCatchBlocks) {
            String id = this.getCatchId(tryCatchNode.handler);
            if (tryCatchNode.start == labelNode) {
                this.currentCatchList.add(id);
                continue;
            }
            if (tryCatchNode.end != labelNode) continue;
            this.currentCatchList.remove(id);
        }
    }

    @Nonnull
    private String getCatchId(@Nonnull LabelNode labelNode) {
        int insnIndex = this.currentMethod.instructions.indexOf(labelNode);
        return Integer.toString(insnIndex) + "-catch";
    }

    private void writeLabelInsn(@Nonnegative int insnIdx) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.LABELED_STATEMENT);
        this.writer.writeOpen();
        String id = Integer.toString(insnIdx);
        this.writer.writeString(id);
        this.writer.writeId(id);
        this.writeEmptyBlock();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeEmptyBlock() throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.BLOCK);
        this.writer.writeOpen();
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull IincInsnNode iincInsn) throws IOException {
        if (nextFrame.getLocal(iincInsn.var) != BasicValue.UNINITIALIZED_VALUE) {
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeCatchBlockIds(this.currentCatchList);
            this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
            this.writer.writeOpen();
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeKeyword(Token.ASG_OPERATION);
            this.writer.writeOpen();
            this.writeLocalAccess(nextFrame, iincInsn.var);
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeKeyword(Token.ADD_OPERATION);
            this.writer.writeOpen();
            this.writeLocalAccess(frame, iincInsn.var);
            this.writeValue(iincInsn.incr, this.currentClass, this.currentLine);
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
        }
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull IntInsnNode intInsn) throws IOException {
        if (intInsn.getOpcode() == 16 || intInsn.getOpcode() == 17) {
            this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), intInsn.operand);
            return;
        }
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        block0 : switch (intInsn.getOpcode()) {
            case 188: {
                switch (intInsn.operand) {
                    case 4: {
                        this.writeNewArray(frame, "[Z", 1);
                        break block0;
                    }
                    case 5: {
                        this.writeNewArray(frame, "[C", 1);
                        break block0;
                    }
                    case 6: {
                        this.writeNewArray(frame, "[F", 1);
                        break block0;
                    }
                    case 7: {
                        this.writeNewArray(frame, "[D", 1);
                        break block0;
                    }
                    case 8: {
                        this.writeNewArray(frame, "[B", 1);
                        break block0;
                    }
                    case 9: {
                        this.writeNewArray(frame, "[S", 1);
                        break block0;
                    }
                    case 10: {
                        this.writeNewArray(frame, "[I", 1);
                        break block0;
                    }
                    case 11: {
                        this.writeNewArray(frame, "[J", 1);
                        break block0;
                    }
                }
                throw new JillException("Unsupported array type.");
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[intInsn.getOpcode()]);
            }
        }
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull MultiANewArrayInsnNode manaIns) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        this.writeNewArray(frame, manaIns.desc, manaIns.dims);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeNewArray(@Nonnull Frame<BasicValue> frame, @Nonnull String typeDesc, @Nonnegative int dims) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.NEW_ARRAY);
        this.writer.writeOpen();
        this.writer.writeId(typeDesc);
        this.writer.writeOpenNodeList();
        for (int i = dims - 1; i >= 0; --i) {
            this.readStack(frame, -1 - i);
        }
        this.writer.writeCloseNodeList();
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeArrayRef(@Nonnull Frame<BasicValue> frame, int startIdx, @Nonnegative int opcode) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ARRAY_REF);
        this.writer.writeOpen();
        Type refType = frame.getStack(frame.getStackSize() + startIdx).getType();
        assert (refType.getSort() == 9 || "null".equals(refType.getInternalName()));
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.REINTERPRETCAST_OPERATION);
        this.writer.writeOpen();
        switch (opcode) {
            case 51: 
            case 84: {
                if (refType.getDescriptor().equals("[Z")) {
                    this.writer.writeId(Type.getType("[Z").getDescriptor());
                    break;
                }
                this.writer.writeId(Type.getType("[B").getDescriptor());
                break;
            }
            case 52: 
            case 85: {
                this.writer.writeId(Type.getType("[C").getDescriptor());
                break;
            }
            case 53: 
            case 86: {
                this.writer.writeId(Type.getType("[S").getDescriptor());
                break;
            }
            case 46: 
            case 79: {
                this.writer.writeId(Type.getType("[I").getDescriptor());
                break;
            }
            case 47: 
            case 80: {
                this.writer.writeId(Type.getType("[J").getDescriptor());
                break;
            }
            case 48: 
            case 81: {
                this.writer.writeId(Type.getType("[F").getDescriptor());
                break;
            }
            case 49: 
            case 82: {
                this.writer.writeId(Type.getType("[D").getDescriptor());
                break;
            }
            case 50: 
            case 83: {
                this.writer.writeId(Type.getType("[Ljava/lang/Object;").getDescriptor());
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[opcode]);
            }
        }
        this.readStack(frame, startIdx);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.readStack(frame, startIdx + 1);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull LookupSwitchInsnNode switchInsn, @Nonnegative int idx) throws IOException {
        ArrayList<String> cases = new ArrayList<String>();
        ArrayList<Case> casesLabelNodeAndKey = new ArrayList<Case>();
        Case defaultCase = new Case(switchInsn.dflt, idx, null);
        casesLabelNodeAndKey.add(defaultCase);
        cases.add(defaultCase.caseId);
        int caseIdx = 0;
        for (LabelNode labelNode : switchInsn.labels) {
            Case c = new Case(labelNode, idx, switchInsn.keys.get(caseIdx++));
            casesLabelNodeAndKey.add(c);
            cases.add(c.caseId);
        }
        this.writeSwitch(frame, cases, casesLabelNodeAndKey);
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull TableSwitchInsnNode switchInsn, @Nonnegative int idx) throws IOException {
        ArrayList<String> cases = new ArrayList<String>();
        ArrayList<Case> casesLabelNodeAndKey = new ArrayList<Case>();
        Case defaultCase = new Case(switchInsn.dflt, idx, null);
        casesLabelNodeAndKey.add(defaultCase);
        cases.add(defaultCase.caseId);
        int key = switchInsn.min;
        for (LabelNode labelNode : switchInsn.labels) {
            Case c = new Case(labelNode, idx, key++);
            casesLabelNodeAndKey.add(c);
            cases.add(c.caseId);
        }
        this.writeSwitch(frame, cases, casesLabelNodeAndKey);
    }

    private void writeSwitch(@Nonnull Frame<BasicValue> frame, @Nonnull List<String> cases, @Nonnull List<Case> casesLabelNodeAndKey) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.SWITCH_STATEMENT);
        this.writer.writeOpen();
        this.readStack(frame, -1);
        this.writer.writeIds(cases);
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.BLOCK);
        this.writer.writeOpen();
        this.writer.writeOpenNodeList();
        for (Case c : casesLabelNodeAndKey) {
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeCatchBlockIds(this.currentCatchList);
            this.writer.writeKeyword(Token.CASE_STATEMENT);
            this.writer.writeOpen();
            this.writer.writeId(c.caseId);
            if (c.key == null) {
                this.writer.writeNull();
            } else {
                this.writeValue(c.key, this.currentClass, this.currentLine);
            }
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
            this.writeGoto(c.labelNode);
        }
        this.writer.writeCloseNodeList();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull TypeInsnNode typeInsn) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        String descriptor = Type.getObjectType(typeInsn.desc).getDescriptor();
        switch (typeInsn.getOpcode()) {
            case 187: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ALLOC);
                this.writer.writeOpen();
                this.writer.writeId(descriptor);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 189: {
                this.writeNewArray(frame, "[" + descriptor, 1);
                break;
            }
            case 193: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.REINTERPRETCAST_OPERATION);
                this.writer.writeOpen();
                this.writer.writeId(Type.BOOLEAN_TYPE.getDescriptor());
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.INSTANCE_OF);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writer.writeId(descriptor);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 192: {
                this.writeCastOperation(Token.DYNAMIC_CAST_OPERATION, frame, descriptor, -1);
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[typeInsn.getOpcode()]);
            }
        }
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull FieldInsnNode fldInsn) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        switch (fldInsn.getOpcode()) {
            case 181: {
                this.writeInstanceFieldRef(fldInsn, frame, -2);
                if (Type.getType(fldInsn.desc) == Type.BOOLEAN_TYPE) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, Type.BOOLEAN_TYPE.getDescriptor(), -1);
                    break;
                }
                this.readStack(frame, -1);
                break;
            }
            case 179: {
                this.writeStaticFieldRef(fldInsn);
                if (Type.getType(fldInsn.desc) == Type.BOOLEAN_TYPE) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, Type.BOOLEAN_TYPE.getDescriptor(), -1);
                    break;
                }
                this.readStack(frame, -1);
                break;
            }
            case 180: {
                this.writeStack(nextFrame, -1);
                if (Type.getType(fldInsn.desc) == Type.BOOLEAN_TYPE) {
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeKeyword(Token.REINTERPRETCAST_OPERATION);
                    this.writer.writeOpen();
                    this.writer.writeId(Type.INT_TYPE.getDescriptor());
                    this.writeInstanceFieldRef(fldInsn, frame, -1);
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    break;
                }
                this.writeInstanceFieldRef(fldInsn, frame, -1);
                break;
            }
            case 178: {
                this.writeStack(nextFrame, -1);
                if (Type.getType(fldInsn.desc) == Type.BOOLEAN_TYPE) {
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeKeyword(Token.REINTERPRETCAST_OPERATION);
                    this.writer.writeOpen();
                    this.writer.writeId(Type.INT_TYPE.getDescriptor());
                    this.writeStaticFieldRef(fldInsn);
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    break;
                }
                this.writeStaticFieldRef(fldInsn);
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[fldInsn.getOpcode()]);
            }
        }
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private boolean isCallToPolymorphicMethod(@Nonnull MethodInsnNode mthInsn) {
        return mthInsn.owner.equals("java/lang/invoke/MethodHandle") && (mthInsn.name.equals("invoke") || mthInsn.name.equals("invokeExact"));
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull MethodInsnNode mthInsn) throws IOException {
        switch (mthInsn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodCallReceiverKind receiverKind;
                MethodKind methodKind;
                DispatchKind dispatchKind;
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                Type returnType = Type.getReturnType(mthInsn.desc);
                if (returnType != Type.VOID_TYPE) {
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeKeyword(Token.ASG_OPERATION);
                    this.writer.writeOpen();
                    this.writeStack(nextFrame, -1);
                    if (returnType == Type.BOOLEAN_TYPE) {
                        this.writeDebugBegin(this.currentClass, this.currentLine);
                        this.writer.writeKeyword(Token.REINTERPRETCAST_OPERATION);
                        this.writer.writeOpen();
                        this.writer.writeId(Type.INT_TYPE.getDescriptor());
                    }
                }
                switch (mthInsn.getOpcode()) {
                    case 185: {
                        dispatchKind = DispatchKind.VIRTUAL;
                        methodKind = MethodKind.INSTANCE_VIRTUAL;
                        receiverKind = MethodCallReceiverKind.INTERFACE;
                        break;
                    }
                    case 184: {
                        dispatchKind = DispatchKind.DIRECT;
                        methodKind = MethodKind.STATIC;
                        receiverKind = MethodCallReceiverKind.CLASS;
                        break;
                    }
                    case 182: {
                        dispatchKind = DispatchKind.VIRTUAL;
                        methodKind = MethodKind.INSTANCE_VIRTUAL;
                        receiverKind = MethodCallReceiverKind.CLASS;
                        break;
                    }
                    case 183: {
                        if (mthInsn.owner.equals(this.currentClass.name) || mthInsn.name.equals("<init>")) {
                            dispatchKind = DispatchKind.DIRECT;
                            methodKind = MethodKind.INSTANCE_NON_VIRTUAL;
                            receiverKind = MethodCallReceiverKind.CLASS;
                            break;
                        }
                        dispatchKind = DispatchKind.DIRECT;
                        methodKind = MethodKind.INSTANCE_VIRTUAL;
                        receiverKind = MethodCallReceiverKind.CLASS;
                        break;
                    }
                    default: {
                        throw new JillException("Opcode not supported " + Printer.OPCODES[mthInsn.getOpcode()]);
                    }
                }
                this.writeDebugBegin(this.currentClass, this.currentLine);
                boolean isCallToPolymorphicMethod = this.isCallToPolymorphicMethod(mthInsn);
                this.writer.writeKeyword(isCallToPolymorphicMethod ? Token.POLYMORPHIC_CALL : Token.METHOD_CALL);
                this.writer.writeOpen();
                Type receiverType = Type.getObjectType(mthInsn.owner);
                int stackArgIndex = Type.getArgumentTypes(mthInsn.desc).length;
                if (mthInsn.getOpcode() == 184) {
                    this.writer.writeNull();
                } else {
                    if (receiverType.equals(frame.getStack(frame.getStackSize() - ++stackArgIndex).getType()) && !isCallToPolymorphicMethod || mthInsn.name.equals("<init>")) {
                        this.readStack(frame, -stackArgIndex);
                    } else {
                        this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, receiverType.getDescriptor(), -stackArgIndex);
                    }
                    --stackArgIndex;
                }
                if (receiverType.getSort() == 9) {
                    receiverType = Type.getType(Object.class);
                }
                this.writer.writeId(receiverType.getDescriptor());
                this.writer.writeReceiverKindEnum(receiverKind);
                this.writer.writeId(this.updateMethodNameForLambdaIfNeeded(mthInsn.name));
                Type[] argumentTypes = Type.getArgumentTypes(mthInsn.desc);
                ArrayList<String> argsTypeIds = new ArrayList<String>(argumentTypes.length);
                for (Type argType : argumentTypes) {
                    argsTypeIds.add(argType.getDescriptor());
                }
                if (isCallToPolymorphicMethod) {
                    ArrayList<String> changedArgsTypeIds = new ArrayList<String>(1);
                    changedArgsTypeIds.add("[Ljava/lang/Object;");
                    this.writer.writeIds(changedArgsTypeIds);
                } else {
                    this.writer.writeIds(argsTypeIds);
                }
                this.writer.writeMethodKindEnum(methodKind);
                if (isCallToPolymorphicMethod) {
                    this.writer.writeId("Ljava/lang/Object;");
                } else {
                    this.writer.writeId(returnType.getDescriptor());
                }
                int argIdx = 0;
                this.writer.writeOpenNodeList();
                while (stackArgIndex > 0) {
                    Type argType;
                    if ((argType = argumentTypes[argIdx++]).getSort() == 10 || argType.getSort() == 9 || argType.getSort() == 3 || argType.getSort() == 2 || argType.getSort() == 4 || argType.getSort() == 1) {
                        this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, argType.getDescriptor(), -stackArgIndex);
                    } else {
                        this.readStack(frame, -stackArgIndex);
                    }
                    --stackArgIndex;
                }
                this.writer.writeCloseNodeList();
                if (isCallToPolymorphicMethod) {
                    this.writer.writeId(returnType.getDescriptor());
                    this.writer.writeIds(argsTypeIds);
                } else {
                    this.writer.writeDispatchKindEnum(dispatchKind);
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                if (returnType != Type.VOID_TYPE) {
                    if (returnType == Type.BOOLEAN_TYPE) {
                        this.writeDebugEnd(this.currentClass, this.currentLine);
                        this.writer.writeClose();
                    }
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[mthInsn.getOpcode()]);
            }
        }
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame, @Nonnull VarInsnNode varInsn) throws IOException {
        switch (varInsn.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(nextFrame, -1);
                if (this.getLocalVariable(frame, varInsn.var).getType() == Type.BOOLEAN_TYPE) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, this.getLocalVariable(frame, varInsn.var), Type.INT_TYPE.getDescriptor());
                } else {
                    this.writeLocalAccess(frame, varInsn.var);
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (nextFrame.getLocal(varInsn.var) == BasicValue.UNINITIALIZED_VALUE) break;
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeLocalAccess(nextFrame, varInsn.var);
                Type destType = this.getLocalVariable(nextFrame, varInsn.var).getType();
                if (destType == Type.BOOLEAN_TYPE) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, Type.BOOLEAN_TYPE.getDescriptor(), -1);
                } else if (this.getStackVariable(frame, -1).getType() != destType) {
                    this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, destType.getDescriptor(), -1);
                } else {
                    this.readStack(frame, -1);
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[varInsn.getOpcode()]);
            }
        }
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @CheckForNull Frame<BasicValue> nextFrame, @Nonnull InsnNode insn) throws IOException {
        switch (insn.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                assert (nextFrame != null);
                this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), insn.getOpcode() - 3);
                break;
            }
            case 1: {
                assert (nextFrame != null);
                this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), null);
                break;
            }
            case 9: 
            case 10: {
                assert (nextFrame != null);
                this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), insn.getOpcode() - 9);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                assert (nextFrame != null);
                this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), new Float(insn.getOpcode() - 11));
                break;
            }
            case 14: 
            case 15: {
                assert (nextFrame != null);
                this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), new Double(insn.getOpcode() - 14));
                break;
            }
            case 133: 
            case 140: 
            case 143: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Long.TYPE, frame, nextFrame);
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Float.TYPE, frame, nextFrame);
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Double.TYPE, frame, nextFrame);
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Integer.TYPE, frame, nextFrame);
                break;
            }
            case 145: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Byte.TYPE, frame, nextFrame);
                break;
            }
            case 146: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Character.TYPE, frame, nextFrame);
                break;
            }
            case 147: {
                assert (nextFrame != null);
                this.writePrimitiveTypeConversion(Short.TYPE, frame, nextFrame);
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                this.writeReturn(frame, -1);
                break;
            }
            case 172: 
            case 176: {
                Type returnType = Type.getReturnType(this.currentMethod.desc);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.RETURN_STATEMENT);
                this.writer.writeOpen();
                this.writeCastOperation(Token.REINTERPRETCAST_OPERATION, frame, returnType.getDescriptor(), -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 177: {
                this.writeReturn(frame, 0);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.ADD_OPERATION, frame, nextFrame);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                assert (nextFrame != null);
                Variable result = this.getStackVariable(nextFrame, -1);
                this.cmpOperands.put(result, new CmpOperands(insn.getOpcode(), frame, -2, frame, -1));
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.SUB_OPERATION, frame, nextFrame);
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.MUL_OPERATION, frame, nextFrame);
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.DIV_OPERATION, frame, nextFrame);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.MOD_OPERATION, frame, nextFrame);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                assert (nextFrame != null);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(nextFrame, -1);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.PREFIX_NEG_OPERATION);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 120: 
            case 121: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.SHL_OPERATION, frame, nextFrame);
                break;
            }
            case 122: 
            case 123: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.SHR_OPERATION, frame, nextFrame);
                break;
            }
            case 124: 
            case 125: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.SHRU_OPERATION, frame, nextFrame);
                break;
            }
            case 126: 
            case 127: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.BIT_AND_OPERATION, frame, nextFrame);
                break;
            }
            case 128: 
            case 129: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.BIT_OR_OPERATION, frame, nextFrame);
                break;
            }
            case 130: 
            case 131: {
                assert (nextFrame != null);
                this.writeBinaryOperation(Token.BIT_XOR_OPERATION, frame, nextFrame);
                break;
            }
            case 190: {
                assert (nextFrame != null);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(nextFrame, -1);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ARRAY_LENGTH);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                assert (nextFrame != null);
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(nextFrame, -1);
                this.writeArrayRef(frame, -2, insn.getOpcode());
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeArrayRef(frame, -3, insn.getOpcode());
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 194: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.LOCK);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 195: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.UNLOCK);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 95: {
                Variable tmpVar = this.getTempVarFromTopOfStackMinus1(frame);
                boolean topMinus1IsVirtual = this.isVirtualStackVariable(frame, -2);
                boolean topIsVirtual = this.isVirtualStackVariable(frame, -1);
                if (topMinus1IsVirtual) {
                    this.cmpOperands.put(this.getStackVariable(nextFrame, -1), this.cmpOperands.remove(this.getStackVariable(frame, -2)));
                } else {
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeCatchBlockIds(this.currentCatchList);
                    this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                    this.writer.writeOpen();
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeKeyword(Token.ASG_OPERATION);
                    this.writer.writeOpen();
                    this.writeLocalRef(tmpVar);
                    this.readStack(frame, -2);
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                }
                if (topIsVirtual) {
                    this.cmpOperands.put(this.getStackVariable(nextFrame, -2), this.cmpOperands.remove(this.getStackVariable(frame, -1)));
                } else {
                    this.writeAssign(frame, -1, nextFrame, -2);
                }
                if (topMinus1IsVirtual) break;
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
                this.writer.writeOpen();
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(Token.ASG_OPERATION);
                this.writer.writeOpen();
                this.writeStack(nextFrame, -1);
                this.writeLocalRef(tmpVar);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 89: {
                assert (nextFrame != null);
                this.writeDup(frame, nextFrame);
                break;
            }
            case 92: {
                assert (nextFrame != null);
                if (frame.getStack(frame.getStackSize() + -1).getSize() == 1) {
                    assert (frame.getStack(frame.getStackSize() + -1 - 1).getSize() == 1);
                    this.writeDup2(frame, nextFrame);
                    break;
                }
                this.writeDup(frame, nextFrame);
                break;
            }
            case 90: {
                assert (nextFrame != null);
                assert (frame.getStack(frame.getStackSize() + -1).getSize() == 1);
                assert (frame.getStack(frame.getStackSize() + -1 - 1).getSize() == 1);
                this.writeDupX1(frame, nextFrame);
                break;
            }
            case 91: {
                assert (nextFrame != null);
                Variable value1 = this.getStackVariable(frame, -1);
                Variable value2 = this.getStackVariable(frame, -2);
                assert (value1.getType().getSize() == 1);
                if (value2.getType().getSize() == 1) {
                    Variable value3 = this.getStackVariable(frame, -3);
                    assert (value3.getType().getSize() == 1);
                    this.writeDupX2(frame, nextFrame);
                    break;
                }
                this.writeDupX1(frame, nextFrame);
                break;
            }
            case 93: {
                assert (nextFrame != null);
                Variable value1 = this.getStackVariable(frame, -1);
                Variable value2 = this.getStackVariable(frame, -2);
                assert (value2.getType().getSize() == 1);
                if (value1.getType().getSize() == 1) {
                    Variable value3 = this.getStackVariable(frame, -3);
                    assert (value3.getType().getSize() == 1);
                    this.writeDup2X1(frame, nextFrame);
                    break;
                }
                this.writeDupX1(frame, nextFrame);
                break;
            }
            case 94: {
                assert (nextFrame != null);
                Variable value1 = this.getStackVariable(frame, -1);
                Variable value2 = this.getStackVariable(frame, -2);
                if (value1.getType().getSize() == 1) {
                    Variable value3 = this.getStackVariable(frame, -3);
                    if (value3.getType().getSize() == 1) {
                        Variable value4 = this.getStackVariable(frame, -4);
                        assert (value4.getType().getSize() == 1);
                        this.writeDup2X2(frame, nextFrame);
                        break;
                    }
                    this.writeDup2X1(frame, nextFrame);
                    break;
                }
                if (value2.getType().getSize() == 1) {
                    Variable value3 = this.getStackVariable(frame, -3);
                    assert (value3.getType().getSize() == 1);
                    this.writeDupX2(frame, nextFrame);
                    break;
                }
                this.writeDupX1(frame, nextFrame);
                break;
            }
            case 87: {
                if (this.isVirtualStackVariable(frame, -1)) {
                    this.cmpOperands.remove(this.getStackVariable(frame, -1));
                }
                this.removeStackVariableConstant(frame, -1);
                break;
            }
            case 0: {
                break;
            }
            case 88: {
                if (this.isVirtualStackVariable(frame, -1)) {
                    this.cmpOperands.remove(this.getStackVariable(frame, -1));
                }
                if (this.getStackVariable(frame, -1).getType().getSize() == 1) {
                    if (this.isVirtualStackVariable(frame, -2)) {
                        this.cmpOperands.remove(this.getStackVariable(frame, -2));
                    }
                    this.removeStackVariableConstant(frame, -1);
                    this.removeStackVariableConstant(frame, -2);
                    break;
                }
                this.removeStackVariableConstant(frame, -1);
                break;
            }
            case 191: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.THROW_STATEMENT);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[insn.getOpcode()]);
            }
        }
    }

    private boolean isVirtualStackVariable(@Nonnull Frame<BasicValue> frame, int stackIdx) {
        Variable stackVar = this.getStackVariable(frame, stackIdx);
        return this.cmpOperands.containsKey(stackVar);
    }

    private void writeInsn(@Nonnull Frame<BasicValue> nextFrame, @Nonnull LdcInsnNode ldcInsn) {
        this.varWithCstValue.put(this.getStackVariable(nextFrame, -1), ldcInsn.cst);
    }

    private void writeInsn(@Nonnull Frame<BasicValue> frame, @Nonnull JumpInsnNode jumpInsn, @Nonnegative int insIndex) throws IOException {
        switch (jumpInsn.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                Variable topOfStackVariable = this.getStackVariable(frame, -1);
                CmpOperands cmpOps = this.cmpOperands.get(topOfStackVariable);
                if (cmpOps != null) {
                    assert (jumpInsn.getOpcode() != 199 && jumpInsn.getOpcode() != 198);
                    Token comparisonToken = this.getConditionToken(jumpInsn.getOpcode());
                    boolean needNotoperator = this.needNotOperator(comparisonToken, cmpOps);
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeCatchBlockIds(this.currentCatchList);
                    this.writer.writeKeyword(Token.IF_STATEMENT);
                    this.writer.writeOpen();
                    if (needNotoperator) {
                        this.writeDebugBegin(this.currentClass, this.currentLine);
                        this.writer.writeKeyword(Token.PREFIX_NOT_OPERATION);
                        this.writer.writeOpen();
                    } else {
                        comparisonToken = this.invertComparisonToken(comparisonToken);
                    }
                    this.writeDebugBegin(this.currentClass, this.currentLine);
                    this.writer.writeKeyword(comparisonToken);
                    this.writer.writeOpen();
                    this.readStack(cmpOps.lhsFrame, cmpOps.lhsStackIdx);
                    this.readStack(cmpOps.rhsFrame, cmpOps.rhsStackIdx);
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    if (needNotoperator) {
                        this.writeDebugEnd(this.currentClass, this.currentLine);
                        this.writer.writeClose();
                    }
                    int labeledStatmentIndex = insIndex + 1;
                    this.writer.writeKeyword(Token.BLOCK);
                    this.writer.writeOpen();
                    this.writer.writeOpenNodeList();
                    this.writeGoto(labeledStatmentIndex);
                    this.writer.writeCloseNodeList();
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    this.writer.writeKeyword(Token.BLOCK);
                    this.writer.writeOpen();
                    this.writer.writeOpenNodeList();
                    this.writeGoto(jumpInsn.label);
                    this.writer.writeCloseNodeList();
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    this.writeDebugEnd(this.currentClass, this.currentLine);
                    this.writer.writeClose();
                    this.insertLabeledStatementIfNecessary(labeledStatmentIndex);
                    this.cmpOperands.remove(topOfStackVariable);
                    break;
                }
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.IF_STATEMENT);
                this.writer.writeOpen();
                Token conditionalToken = this.getConditionToken(jumpInsn.getOpcode());
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(conditionalToken);
                this.writer.writeOpen();
                this.readStack(frame, -1);
                Variable v = this.getStackVariable(frame, -1);
                if (v.getType().equals(Type.BOOLEAN_TYPE)) {
                    this.writeValue(false, this.currentClass, this.currentLine);
                } else if (v.getType().equals(Type.BYTE_TYPE) || v.getType().equals(Type.CHAR_TYPE) || v.getType().equals(Type.SHORT_TYPE) || v.getType().equals(Type.INT_TYPE)) {
                    this.writeValue(0, this.currentClass, this.currentLine);
                } else {
                    this.writeValue(this.currentClass, this.currentLine);
                }
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writer.writeKeyword(Token.BLOCK);
                this.writer.writeOpen();
                this.writer.writeOpenNodeList();
                this.writeGoto(jumpInsn.label);
                this.writer.writeCloseNodeList();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writer.writeNull();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeCatchBlockIds(this.currentCatchList);
                this.writer.writeKeyword(Token.IF_STATEMENT);
                this.writer.writeOpen();
                Token conditionalToken = this.getConditionToken(jumpInsn.getOpcode());
                this.writeDebugBegin(this.currentClass, this.currentLine);
                this.writer.writeKeyword(conditionalToken);
                this.writer.writeOpen();
                this.readStack(frame, -2);
                this.readStack(frame, -1);
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writer.writeKeyword(Token.BLOCK);
                this.writer.writeOpen();
                this.writer.writeOpenNodeList();
                this.writeGoto(jumpInsn.label);
                this.writer.writeCloseNodeList();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                this.writer.writeNull();
                this.writeDebugEnd(this.currentClass, this.currentLine);
                this.writer.writeClose();
                break;
            }
            case 167: {
                this.writeGoto(jumpInsn.label);
                break;
            }
            default: {
                throw new JillException("Not yet supported " + Printer.OPCODES[jumpInsn.getOpcode()]);
            }
        }
    }

    private void insertLabeledStatementIfNecessary(@Nonnegative int labeledStatmentIndex) throws IOException {
        AbstractInsnNode existing = this.currentMethod.instructions.get(labeledStatmentIndex);
        if (existing instanceof LabelNode) {
            return;
        }
        this.writeLabelInsn(labeledStatmentIndex);
    }

    @Nonnull
    private Token getConditionToken(@Nonnegative int opcode) {
        switch (opcode) {
            case 153: 
            case 159: 
            case 165: 
            case 198: {
                return Token.EQ_OPERATION;
            }
            case 156: 
            case 162: {
                return Token.GTE_OPERATION;
            }
            case 157: 
            case 163: {
                return Token.GT_OPERATION;
            }
            case 158: 
            case 164: {
                return Token.LTE_OPERATION;
            }
            case 155: 
            case 161: {
                return Token.LT_OPERATION;
            }
            case 154: 
            case 160: 
            case 166: 
            case 199: {
                return Token.NEQ_OPERATION;
            }
        }
        throw new JillException("Unsupported condition.");
    }

    @Nonnull
    private Token invertComparisonToken(@Nonnull Token cmpToken) {
        switch (cmpToken) {
            case GTE_OPERATION: {
                return Token.LT_OPERATION;
            }
            case GT_OPERATION: {
                return Token.LTE_OPERATION;
            }
            case LTE_OPERATION: {
                return Token.GT_OPERATION;
            }
            case LT_OPERATION: {
                return Token.GTE_OPERATION;
            }
            case EQ_OPERATION: {
                return Token.NEQ_OPERATION;
            }
            case NEQ_OPERATION: {
                return Token.EQ_OPERATION;
            }
        }
        return cmpToken;
    }

    @Nonnull
    private boolean needNotOperator(@Nonnull Token cmpToken, @Nonnull CmpOperands cmpOps) {
        switch (cmpToken) {
            case GTE_OPERATION: 
            case GT_OPERATION: {
                return !this.isCmpg(cmpOps);
            }
            case LTE_OPERATION: 
            case LT_OPERATION: {
                return !this.isCmpl(cmpOps);
            }
        }
        return false;
    }

    private boolean isCmpl(@Nonnull CmpOperands cmpOps) {
        return cmpOps.opcode == 151 || cmpOps.opcode == 149;
    }

    private boolean isCmpg(@Nonnull CmpOperands cmpOps) {
        return cmpOps.opcode == 152 || cmpOps.opcode == 150;
    }

    private void writeGoto(LabelNode labelNode) throws IOException {
        int insIndex = this.currentMethod.instructions.indexOf(labelNode);
        this.writeGoto(insIndex);
    }

    private void writeGoto(int insIndex) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.GOTO);
        this.writer.writeOpen();
        this.writer.writeId(Integer.toString(insIndex));
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeReturn(@Nonnull Frame<BasicValue> frame, int stackIdx) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.RETURN_STATEMENT);
        this.writer.writeOpen();
        if (stackIdx == 0) {
            this.writer.writeNull();
        } else {
            this.readStack(frame, stackIdx);
        }
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeStack(@Nonnull Frame<BasicValue> frame, int stackIdx) throws IndexOutOfBoundsException, IOException {
        this.writeLocalRef(this.getStackVariable(frame, stackIdx));
    }

    private void readStack(@Nonnull Frame<BasicValue> frame, int stackIdx) throws IndexOutOfBoundsException, IOException {
        Variable stackVariable = this.getStackVariable(frame, stackIdx);
        if (this.varWithCstValue.containsKey(stackVariable)) {
            this.writeValue(this.varWithCstValue.remove(stackVariable), this.currentClass, this.currentLine);
        } else {
            this.writeLocalRef(stackVariable);
        }
    }

    private void writeLocalAccess(@Nonnull Frame<BasicValue> frame, @Nonnegative int localIdx) throws IndexOutOfBoundsException, IOException {
        this.writeLocalRef(this.getLocalVariable(frame, localIdx));
    }

    private void writeLocalRef(@Nonnull Variable v) throws IOException {
        if (v.isThis()) {
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeKeyword(Token.THIS_REF);
            this.writer.writeOpen();
            this.writer.writeId(v.getType().getDescriptor());
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
        } else {
            Token token = v.isParameter() ? Token.PARAMETER_REF : Token.LOCAL_REF;
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeKeyword(token);
            this.writer.writeOpen();
            this.writer.writeId(v.getId());
            this.writer.writeOpenNodeList();
            this.writeDebugInformation(v);
            this.writer.writeCloseNodeList();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
        }
    }

    private void writeDebugInformation(@Nonnull Variable v) throws IOException {
        if (!v.hasLocalIndex()) {
            return;
        }
        LocalVariableNode lvn = this.getLocalVariableNode(v.getLocalIndex());
        if (lvn != null) {
            this.writer.writeKeyword(Token.DEBUG_VARIABLE_INFORMATION);
            this.writer.writeOpen();
            this.writer.writeString(lvn.name);
            this.writer.writeId(lvn.desc);
            this.writer.writeString(lvn.signature);
            this.writer.writeClose();
        } else if (v.isParameter()) {
            this.writer.writeKeyword(Token.DEBUG_VARIABLE_INFORMATION);
            this.writer.writeOpen();
            this.writer.writeString(null);
            this.writer.writeId(null);
            this.writer.writeString(null);
            this.writer.writeClose();
        }
    }

    private void writeInstanceFieldRef(@Nonnull FieldInsnNode fldInsn, @Nonnull Frame<BasicValue> frame, int offset) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.FIELD_REF);
        this.writer.writeOpen();
        this.writer.writeId(fldInsn.name);
        this.writer.writeId(fldInsn.desc);
        this.writer.writeId(Type.getObjectType(fldInsn.owner).getDescriptor());
        this.writer.writeFieldRefKindEnum(FieldRefKind.INSTANCE);
        this.readStack(frame, offset);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeStaticFieldRef(@Nonnull FieldInsnNode fldInsn) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.FIELD_REF);
        this.writer.writeOpen();
        this.writer.writeId(fldInsn.name);
        this.writer.writeId(fldInsn.desc);
        this.writer.writeId(Type.getObjectType(fldInsn.owner).getDescriptor());
        this.writer.writeFieldRefKindEnum(FieldRefKind.STATIC);
        this.writer.writeNull();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    public void dump() {
        Textifier t = new Textifier();
        Frame<BasicValue>[] frames = this.analyzer.getFrames();
        List<Object> text = t.getText();
        int insnIdx = 0;
        this.currentMethod.accept(new TraceMethodVisitor(t));
        for (Object o : text) {
            if (insnIdx < frames.length && frames[insnIdx] != null) {
                BasicValue bv;
                int i;
                System.out.print(insnIdx + " : [");
                for (i = 0; i < frames[insnIdx].getLocals(); ++i) {
                    bv = frames[insnIdx].getLocal(i);
                    System.out.print(bv.toString() + " ");
                }
                System.out.print("| ");
                for (i = 0; i < frames[insnIdx].getStackSize(); ++i) {
                    bv = frames[insnIdx].getStack(i);
                    System.out.print(bv.toString() + " ");
                }
                System.out.println("]");
            }
            System.out.print(o);
            ++insnIdx;
        }
    }

    private void writeLocals() throws IOException {
        this.writer.writeOpenNodeList();
        if (this.currentMethod.instructions.size() != 0) {
            Iterator<Variable> varIt = this.collectLocals();
            while (varIt.hasNext()) {
                this.writeLocal(varIt.next());
            }
        }
        this.writer.writeCloseNodeList();
    }

    private void writeLocal(Variable v) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.LOCAL);
        this.writer.writeOpen();
        this.writer.writeId(v.getId());
        this.writer.writeInt(v.getModifier());
        this.writer.writeId(v.getType().getDescriptor());
        this.writer.writeId(v.getName());
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    private void writePrimitiveTypeConversion(@Nonnull Class<?> targetType, @Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        this.writeCastOperation(Token.DYNAMIC_CAST_OPERATION, frame, Type.getDescriptor(targetType), -1);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeCastOperation(@Nonnull Token cast, @Nonnull Variable var, @Nonnull String typeDesc) throws IOException {
        assert (cast == Token.DYNAMIC_CAST_OPERATION || cast == Token.REINTERPRETCAST_OPERATION);
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(cast);
        this.writer.writeOpen();
        if (cast == Token.DYNAMIC_CAST_OPERATION) {
            ArrayList<String> types = new ArrayList<String>(1);
            types.add(typeDesc);
            this.writer.writeIds(types);
        } else {
            this.writer.writeId(typeDesc);
        }
        this.writeLocalRef(var);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeCastOperation(@Nonnull Token cast, @Nonnull Frame<BasicValue> frame, @Nonnull String typeDesc, int stackIdx) throws IOException {
        assert (cast == Token.DYNAMIC_CAST_OPERATION || cast == Token.REINTERPRETCAST_OPERATION);
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(cast);
        this.writer.writeOpen();
        if (cast == Token.DYNAMIC_CAST_OPERATION) {
            ArrayList<String> types = new ArrayList<String>(1);
            types.add(typeDesc);
            this.writer.writeIds(types);
        } else {
            this.writer.writeId(typeDesc);
        }
        this.readStack(frame, stackIdx);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    private void writeDup(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        if (this.isVirtualStackVariable(frame, -1)) {
            this.cmpOperands.put(this.getStackVariable(nextFrame, -1), this.cmpOperands.get(this.getStackVariable(frame, -1)));
        } else {
            this.writeAssign(frame, -1, nextFrame, -1);
        }
    }

    private void writeDupX1(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        this.writeAssign(frame, -1, nextFrame, -1);
        this.removeStackVariableConstant(frame, -1);
        this.writeAssign(frame, -2, nextFrame, -2);
        this.removeStackVariableConstant(frame, -2);
        this.writeAssign(nextFrame, -1, nextFrame, -3);
    }

    private void removeStackVariableConstant(@Nonnull Frame<BasicValue> frame, int stackIdx) {
        this.varWithCstValue.remove(this.getStackVariable(frame, stackIdx));
    }

    private void writeDupX2(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        this.writeAssign(frame, -1, nextFrame, -1);
        this.removeStackVariableConstant(frame, -1);
        this.writeAssign(frame, -2, nextFrame, -2);
        this.removeStackVariableConstant(frame, -2);
        this.writeAssign(frame, -3, nextFrame, -3);
        this.removeStackVariableConstant(frame, -3);
        this.writeAssign(nextFrame, -1, nextFrame, -4);
    }

    private void writeDup2(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        if (this.isVirtualStackVariable(frame, -1)) {
            this.cmpOperands.put(this.getStackVariable(nextFrame, -1), this.cmpOperands.get(this.getStackVariable(frame, -1)));
        } else {
            this.writeAssign(frame, -1, nextFrame, -1);
        }
        if (this.isVirtualStackVariable(frame, -2)) {
            this.cmpOperands.put(this.getStackVariable(nextFrame, -2), this.cmpOperands.get(this.getStackVariable(frame, -2)));
        } else {
            this.writeAssign(frame, -2, nextFrame, -2);
        }
    }

    private void writeDup2X1(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        this.writeAssign(frame, -1, nextFrame, -1);
        this.removeStackVariableConstant(frame, -1);
        this.writeAssign(frame, -2, nextFrame, -2);
        this.removeStackVariableConstant(frame, -2);
        this.writeAssign(frame, -3, nextFrame, -3);
        this.removeStackVariableConstant(frame, -3);
        this.writeAssign(nextFrame, -1, nextFrame, -4);
        this.writeAssign(nextFrame, -2, nextFrame, -5);
    }

    private void writeDup2X2(@Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        this.writeAssign(frame, -1, nextFrame, -1);
        this.removeStackVariableConstant(frame, -1);
        this.writeAssign(frame, -2, nextFrame, -2);
        this.removeStackVariableConstant(frame, -2);
        this.writeAssign(frame, -3, nextFrame, -3);
        this.removeStackVariableConstant(frame, -3);
        this.writeAssign(frame, -4, nextFrame, -4);
        this.removeStackVariableConstant(frame, -4);
        this.writeAssign(nextFrame, -1, nextFrame, -5);
        this.writeAssign(nextFrame, -2, nextFrame, -6);
    }

    private void writeAssign(@Nonnull Frame<BasicValue> frame1, int offset1, @Nonnull Frame<BasicValue> frame2, int offset2) throws IOException {
        assert (!this.isBooleanAssignIssue(this.getStackVariable(frame2, offset2), this.getStackVariable(frame1, offset1)));
        Variable stackVariableRead = this.getStackVariable(frame1, offset1);
        if (this.varWithCstValue.containsKey(stackVariableRead)) {
            this.varWithCstValue.put(this.getStackVariable(frame2, offset2), this.varWithCstValue.get(stackVariableRead));
        } else {
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeCatchBlockIds(this.currentCatchList);
            this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
            this.writer.writeOpen();
            this.writeDebugBegin(this.currentClass, this.currentLine);
            this.writer.writeKeyword(Token.ASG_OPERATION);
            this.writer.writeOpen();
            this.writeStack(frame2, offset2);
            this.readStack(frame1, offset1);
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
            this.writeDebugEnd(this.currentClass, this.currentLine);
            this.writer.writeClose();
        }
    }

    private void writeBinaryOperation(@Nonnull Token op, @Nonnull Frame<BasicValue> frame, @Nonnull Frame<BasicValue> nextFrame) throws IOException {
        assert (!this.isBooleanAssignIssue(this.getStackVariable(frame, -2), this.getStackVariable(frame, -1)));
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeCatchBlockIds(this.currentCatchList);
        this.writer.writeKeyword(Token.EXPRESSION_STATEMENT);
        this.writer.writeOpen();
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(Token.ASG_OPERATION);
        this.writer.writeOpen();
        this.writeStack(nextFrame, -1);
        this.writeDebugBegin(this.currentClass, this.currentLine);
        this.writer.writeKeyword(op);
        this.writer.writeOpen();
        this.readStack(frame, -2);
        this.readStack(frame, -1);
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
        this.writeDebugEnd(this.currentClass, this.currentLine);
        this.writer.writeClose();
    }

    @Nonnull
    private Iterator<Variable> collectLocals() {
        LinkedHashSet<Variable> locals = new LinkedHashSet<Variable>();
        Frame<BasicValue>[] frames = this.analyzer.getFrames();
        for (int frameIdx = 0; frameIdx < frames.length; ++frameIdx) {
            this.currentPc = frameIdx;
            Frame<BasicValue> frame = frames[frameIdx];
            if (frame == null) continue;
            for (int localIdx = 0; localIdx < frame.getLocals(); ++localIdx) {
                Variable local;
                BasicValue bv = frame.getLocal(localIdx);
                if (bv == BasicValue.UNINITIALIZED_VALUE || (local = this.getLocalVariable(frame, localIdx)).isParameter() || local.isThis()) continue;
                locals.add(local);
            }
            for (int stackIdx = 0; stackIdx < frame.getStackSize(); ++stackIdx) {
                Variable v = this.getStackVariable(frame, -stackIdx - 1);
                locals.add(v);
            }
        }
        for (int insnIdx = 0; insnIdx < this.currentMethod.instructions.size(); ++insnIdx) {
            AbstractInsnNode insn = this.currentMethod.instructions.get(insnIdx);
            if (insn.getOpcode() != 95) continue;
            locals.add(this.getTempVarFromTopOfStackMinus1(frames[insnIdx]));
        }
        return locals.iterator();
    }

    @Nonnull
    private Variable getTempVarFromTopOfStackMinus1(@Nonnull Frame<BasicValue> frame) {
        Variable topOfStackBeforeInst = this.getStackVariable(frame, -2);
        String tmpVarId = "-swap_tmp_" + this.typeToUntypedDesc(topOfStackBeforeInst.getType());
        Variable tmpVariable = this.getVariable(tmpVarId, tmpVarId, topOfStackBeforeInst.getType());
        return tmpVariable;
    }

    @CheckForNull
    private String getParameterName(@Nonnegative int parameterIdx) {
        if (this.currentMethod.parameters != null) {
            return this.currentMethod.parameters.get((int)parameterIdx).name;
        }
        return null;
    }

    private int getParameterModifier(@Nonnegative int parameterIdx, @CheckForNull LocalVariableNode lvn) {
        if (this.currentMethod.parameters != null) {
            return this.currentMethod.parameters.get((int)parameterIdx).access | 0x400000;
        }
        if (lvn == null) {
            return 4096;
        }
        return 0;
    }

    private void writeParameters() throws IOException {
        this.writer.writeOpenNodeList();
        int parameterLocalIdx = 0;
        int parameterAnnotationIdx = 0;
        this.currentPc = 0;
        if (!AsmHelper.isStatic(this.currentMethod)) {
            Type parameterType = Type.getObjectType(this.currentClass.name);
            LocalVariableNode lvn = this.getLocalVariableNode(parameterLocalIdx);
            String pid = this.getUnnamedParameterId(parameterLocalIdx, parameterType);
            Variable p = this.getVariableWithLocalIndex(parameterLocalIdx, pid, lvn != null ? lvn.name : pid, parameterType, lvn != null ? lvn.signature : null, lvn == null ? 4096 : 0);
            p.setThis();
            Type untypedParameter = this.typeToUntyped(parameterType);
            String lid = this.getUnnamedLocalId(parameterLocalIdx, untypedParameter);
            Variable local = this.getVariableWithLocalIndex(parameterLocalIdx, lid, lid, untypedParameter, null, lvn == null ? 4096 : 0);
            this.parameter2Var.put(p, local);
            ++parameterLocalIdx;
        }
        int parameterIdx = 0;
        for (Type paramType : Type.getArgumentTypes(this.currentMethod.desc)) {
            LocalVariableNode lvn = this.getLocalVariableNode(parameterLocalIdx);
            String pid = this.getUnnamedParameterId(parameterLocalIdx, paramType);
            Variable p = this.getVariableWithLocalIndex(parameterLocalIdx, pid, this.getParameterName(parameterIdx), paramType, lvn != null ? lvn.signature : null, this.getParameterModifier(parameterIdx, lvn));
            p.setParameter();
            this.writeParameter(paramType, parameterLocalIdx, p, parameterAnnotationIdx++);
            Type untypedParameter = this.typeToUntyped(paramType);
            String lid = this.getUnnamedLocalId(parameterLocalIdx, untypedParameter);
            Variable local = this.getVariableWithLocalIndex(parameterLocalIdx, lid, lid, untypedParameter, null, lvn == null ? 4096 : 0);
            this.parameter2Var.put(p, local);
            parameterLocalIdx += paramType.getSize();
            ++parameterIdx;
        }
        this.writer.writeCloseNodeList();
    }

    private void writeParameter(@Nonnull Type paramType, @Nonnegative int localIdx, @Nonnull Variable param, @Nonnegative int parameterAnnotationIdx) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.PARAMETER);
        this.writer.writeOpen();
        this.writer.writeId(param.getId());
        this.writer.writeInt(param.getModifier());
        this.writer.writeId(paramType.getDescriptor());
        this.writer.writeString(param.getName());
        this.annotWriter.writeAnnotations(this.currentMethod, parameterAnnotationIdx);
        this.writer.writeOpenNodeList();
        if (param.hasSignature()) {
            this.writer.writeKeyword(Token.GENERIC_SIGNATURE);
            this.writer.writeOpen();
            this.writer.writeString(param.getSignature());
            this.writer.writeClose();
        }
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    @CheckForNull
    private LocalVariableNode getLocalVariableNode(@Nonnegative int localIdx) {
        assert (localIdx >= 0);
        if (this.options.isEmitDebugInfo() && this.currentMethod.localVariables != null) {
            for (LocalVariableNode lvn : this.currentMethod.localVariables) {
                int startScope = this.currentMethod.instructions.indexOf(lvn.start) - 1;
                int endScope = this.currentMethod.instructions.indexOf(lvn.end);
                if (lvn.index != localIdx || this.currentPc < startScope || this.currentPc > endScope) continue;
                assert (lvn.desc != null);
                return lvn;
            }
        }
        return null;
    }

    private void removeDeadCode() {
        Frame<BasicValue>[] frames = this.analyzer.getFrames();
        AbstractInsnNode[] insns = this.currentMethod.instructions.toArray();
        for (int i = 0; i < frames.length; ++i) {
            AbstractInsnNode insn;
            if (frames[i] != null || (insn = insns[i]) instanceof LabelNode) continue;
            this.currentMethod.instructions.remove(insn);
        }
    }

    private boolean isBooleanAssignIssue(@Nonnull Variable lhs, @Nonnull Variable rhs) {
        return this.isBooleanAssignIssue(lhs.getType(), rhs.getType());
    }

    private boolean isBooleanAssignIssue(@Nonnull Type lhs, @Nonnull Type rhs) {
        return lhs == Type.BOOLEAN_TYPE && rhs != Type.BOOLEAN_TYPE || rhs == Type.BOOLEAN_TYPE && lhs != Type.BOOLEAN_TYPE;
    }

    @Nonnull
    private Variable getLocalVariable(@Nonnull Frame<BasicValue> frame, @Nonnegative int localIdx) {
        String id;
        BasicValue bv = frame.getLocal(localIdx);
        assert (bv != BasicValue.UNINITIALIZED_VALUE);
        String localName = id = this.getUnnamedLocalId(localIdx, bv.getType());
        Type localType = this.typeToUntyped(bv.getType());
        Variable v = this.getVariableWithLocalIndex(localIdx, id, localName, localType, null, 0);
        return v;
    }

    @Nonnull
    private String getUnnamedParameterId(@Nonnegative int localIdx, @Nonnull Type localType) {
        return "-p_" + localIdx + "_" + this.stringLegalizer(localType.getDescriptor());
    }

    @Nonnull
    private String getUnnamedLocalId(@Nonnegative int localIdx, @Nonnull Type localType) {
        return "-l_" + localIdx + "_" + this.typeToUntypedDesc(localType);
    }

    @Nonnull
    private String getNamedLocalId(@Nonnull LocalVariableNode lvn) {
        return lvn.name + "_" + lvn.index + "_" + (lvn.signature != null ? this.stringLegalizer(lvn.signature) : this.stringLegalizer(lvn.desc));
    }

    @Nonnull
    private Variable getStackVariable(@Nonnull Frame<BasicValue> frame, int stackIdx) {
        int stackHeight = frame.getStackSize() + stackIdx;
        BasicValue bv = frame.getStack(stackHeight);
        assert (bv != BasicValue.UNINITIALIZED_VALUE);
        String id = "-s_" + stackHeight + "_" + this.typeToUntypedDesc(bv.getType());
        Variable variable = this.getVariable(id, id, this.typeToUntyped(bv.getType()));
        return variable;
    }

    @Nonnull
    private Variable getVariable(@Nonnull String id, @Nonnull String name, @Nonnull Type type) {
        Variable var = this.nameToVar.get(id);
        if (var == null) {
            var = new Variable(id, name, type);
            this.nameToVar.put(id, var);
        }
        return var;
    }

    @Nonnull
    private Variable getVariableWithLocalIndex(@Nonnegative int localIdx, @Nonnull String id, @CheckForNull String name, @Nonnull Type type, @CheckForNull String signature, int modifier) {
        Variable var = this.nameToVar.get(id);
        if (var == null) {
            var = new Variable(id, name, type, signature, localIdx, modifier);
            this.nameToVar.put(id, var);
        }
        return var;
    }

    @Nonnull
    private String typeToUntypedDesc(@Nonnull Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return "R";
        }
        if (type.getSort() == 1 || type.getSort() == 3 || type.getSort() == 2 || type.getSort() == 4 || type.getSort() == 5) {
            return Type.INT_TYPE.getDescriptor();
        }
        return type.getDescriptor();
    }

    @Nonnull
    private Type typeToUntyped(@Nonnull Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return Type.getType("Ljava/lang/Object;");
        }
        if (type.getSort() == 1 || type.getSort() == 3 || type.getSort() == 2 || type.getSort() == 4 || type.getSort() == 5) {
            return Type.INT_TYPE;
        }
        return type;
    }

    @Nonnull
    private String stringLegalizer(@Nonnull String str) {
        return str.replace('/', '_').replace(';', '_').replace('<', '_').replace('>', '_').replace(':', '_').replace('[', '_');
    }

    private static class CmpOperands {
        @Nonnegative
        int opcode;
        @Nonnull
        Frame<BasicValue> lhsFrame;
        int lhsStackIdx;
        @Nonnull
        Frame<BasicValue> rhsFrame;
        int rhsStackIdx;

        public CmpOperands(@Nonnegative int opcode, @Nonnull Frame<BasicValue> lhsFrame, int lhsStackIdx, @Nonnull Frame<BasicValue> rhsFrame, int rhsStackIdx) {
            this.opcode = opcode;
            this.lhsFrame = lhsFrame;
            this.lhsStackIdx = lhsStackIdx;
            this.rhsFrame = rhsFrame;
            this.rhsStackIdx = rhsStackIdx;
        }
    }

    private static class Case {
        @Nonnull
        LabelNode labelNode;
        @CheckForNull
        Integer key;
        @Nonnull
        String caseId;

        public Case(@Nonnull LabelNode labelNode, @Nonnegative int switchIdx, @CheckForNull Integer key) {
            this.labelNode = labelNode;
            this.key = key;
            this.caseId = switchIdx + "_" + (this.key != null ? this.key.toString() : "default");
        }
    }

    public static enum FieldRefKind {
        INSTANCE,
        STATIC;

    }

    public static enum MethodCallReceiverKind {
        CLASS,
        INTERFACE;

    }

    public static enum MethodKind {
        STATIC,
        INSTANCE_NON_VIRTUAL,
        INSTANCE_VIRTUAL;

    }

    public static enum DispatchKind {
        VIRTUAL,
        DIRECT;

    }
}

