/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java.analyzer;

import com.android.jill.JillException;
import com.android.jill.google.common.base.Strings;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.objectweb.asm.Type;
import com.android.jill.objectweb.asm.tree.AbstractInsnNode;
import com.android.jill.objectweb.asm.tree.analysis.AnalyzerException;
import com.android.jill.objectweb.asm.tree.analysis.BasicInterpreter;
import com.android.jill.objectweb.asm.tree.analysis.BasicValue;

public class JillAnalyzer
extends BasicInterpreter {
    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return BasicValue.INT_VALUE;
            }
            case 6: {
                return BasicValue.FLOAT_VALUE;
            }
            case 7: {
                return BasicValue.LONG_VALUE;
            }
            case 8: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return new BasicValue(type);
            }
        }
        throw new Error("Internal error");
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        if (insn.getOpcode() == 50) {
            Type arrayType = value1.getType();
            String arrayTypeDesc = arrayType.getDescriptor();
            if (arrayType.getSort() == 9) {
                return this.newValue(Type.getType(arrayTypeDesc.substring(1)));
            }
            if ("Lnull;".equals(arrayTypeDesc)) {
                return value1;
            }
            throw new JillException("Fails to retrieve array element value");
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        assert (v != null);
        assert (w != null);
        if (v.equals(w) || v == BasicValue.UNINITIALIZED_VALUE) {
            return v;
        }
        if (w == BasicValue.UNINITIALIZED_VALUE) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        Type type1 = v.getType();
        Type type2 = w.getType();
        if (type1.getSort() == 9 && type2.getSort() == 10 && !this.isKnownNull(type2) || type1.getSort() == 10 && !this.isKnownNull(type1) && type2.getSort() == 9) {
            return BasicValue.REFERENCE_VALUE;
        }
        if ((type1.getSort() == 9 || this.isKnownNull(type1)) && (type2.getSort() == 9 || this.isKnownNull(type2))) {
            if (this.isKnownNull(type1)) {
                return w;
            }
            if (this.isKnownNull(type2)) {
                return v;
            }
            BasicValue componentUnion = this.merge(new BasicValue(type1.getElementType()), new BasicValue(type2.getElementType()));
            if (componentUnion == BasicValue.UNINITIALIZED_VALUE) {
                return BasicValue.REFERENCE_VALUE;
            }
            return new BasicValue(Type.getType(Strings.repeat("[", Math.min(type1.getDimensions(), type2.getDimensions())) + componentUnion.getType().getDescriptor()));
        }
        if (type1.getSort() == 10 && type2.getSort() == 10) {
            if (this.isKnownNull(type1)) {
                return w;
            }
            if (this.isKnownNull(type2)) {
                return v;
            }
            return BasicValue.REFERENCE_VALUE;
        }
        if (this.isIntLike(type1) && this.isIntLike(type2)) {
            return BasicValue.INT_VALUE;
        }
        return BasicValue.UNINITIALIZED_VALUE;
    }

    private boolean isIntLike(@Nonnull Type t) {
        return t == Type.BOOLEAN_TYPE || t == Type.BYTE_TYPE || t == Type.CHAR_TYPE || t == Type.SHORT_TYPE || t == Type.INT_TYPE;
    }

    private boolean isKnownNull(@Nonnull Type t) {
        return "Lnull;".equals(t.getDescriptor());
    }
}

