/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.kohsuke.args4j;

import com.android.jill.kohsuke.args4j.Argument;
import com.android.jill.kohsuke.args4j.CmdLineException;
import com.android.jill.kohsuke.args4j.CmdLineParser;
import com.android.jill.kohsuke.args4j.Option;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Starter {
    public static final String PARAMETER_NAME = "mainclass";

    public static void main(String[] args) {
        String classname = System.getProperty(PARAMETER_NAME);
        CmdLineParser parser = null;
        boolean classHasArgument = false;
        boolean classHasOptions = false;
        if (classname == null || "".equals(classname)) {
            System.err.println("The system property 'mainclass' must contain the classname to start.");
            System.exit(-1);
        }
        try {
            Method m;
            Class<?> clazz = Class.forName(classname);
            Object bean = clazz.newInstance();
            parser = new CmdLineParser(bean);
            classHasArgument = Starter.hasAnnotation(clazz, Argument.class);
            classHasOptions = Starter.hasAnnotation(clazz, Option.class);
            parser.parseArgument(args);
            boolean couldInvoke = false;
            try {
                m = clazz.getMethod("run", null);
                m.invoke(bean, (Object[])null);
                couldInvoke = true;
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            if (!couldInvoke) {
                try {
                    m = clazz.getMethod("run", String[].class);
                    m.invoke(bean, new Object[]{args});
                    couldInvoke = true;
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cant find the class '" + classname + "' as specified in the system property '" + PARAMETER_NAME + "'.");
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.print(classname);
            if (classHasOptions) {
                System.err.print(" [options]");
            }
            if (classHasArgument) {
                System.err.print(" arguments");
            }
            System.err.println();
            if (parser != null) {
                parser.printUsage(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasAnnotation(Class clazz, Class<? extends Annotation> annotation) {
        if (clazz.getAnnotation(annotation) != null) {
            return true;
        }
        for (Field field : clazz.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (((Method)accessibleObject).getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

