/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.kohsuke.args4j.spi;

import com.android.jill.kohsuke.args4j.CmdLineException;
import com.android.jill.kohsuke.args4j.CmdLineParser;
import com.android.jill.kohsuke.args4j.OptionDef;
import com.android.jill.kohsuke.args4j.spi.Messages;
import com.android.jill.kohsuke.args4j.spi.OptionHandler;
import com.android.jill.kohsuke.args4j.spi.Parameters;
import com.android.jill.kohsuke.args4j.spi.Setter;
import java.util.HashMap;
import java.util.Map;

public class ExplicitBooleanOptionHandler
extends OptionHandler<Boolean> {
    private static final Map<String, Boolean> ACCEPTABLE_VALUES = new HashMap<String, Boolean>();

    public ExplicitBooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        if (params.size() == 0 || params.getParameter(0).startsWith("-")) {
            this.setter.addValue(Boolean.TRUE);
            return 0;
        }
        this.setter.addValue(this.getBoolean(params.getParameter(0)));
        return 1;
    }

    private Boolean getBoolean(String parameter) throws CmdLineException {
        String valueStr = parameter.toLowerCase();
        if (!ACCEPTABLE_VALUES.containsKey(valueStr)) {
            throw new CmdLineException(this.owner, Messages.ILLEGAL_BOOLEAN, valueStr);
        }
        return ACCEPTABLE_VALUES.get(valueStr);
    }

    @Override
    public String getDefaultMetaVariable() {
        return Messages.DEFAULT_META_EXPLICIT_BOOLEAN_OPTION_HANDLER.format(new Object[0]);
    }

    static {
        ACCEPTABLE_VALUES.put("true", Boolean.TRUE);
        ACCEPTABLE_VALUES.put("on", Boolean.TRUE);
        ACCEPTABLE_VALUES.put("yes", Boolean.TRUE);
        ACCEPTABLE_VALUES.put("1", Boolean.TRUE);
        ACCEPTABLE_VALUES.put("false", Boolean.FALSE);
        ACCEPTABLE_VALUES.put("off", Boolean.FALSE);
        ACCEPTABLE_VALUES.put("no", Boolean.FALSE);
        ACCEPTABLE_VALUES.put("0", Boolean.FALSE);
    }
}

