/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.utils;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotListDirException;
import com.android.sched.util.location.DirectoryLocation;
import java.io.File;
import java.util.List;

public class FileUtils {
    @Nonnull
    public static final String JAVA_BINARY_FILE_EXTENSION = ".class";
    @Nonnull
    public static final String JAR_FILE_EXTENSION = ".jar";

    public static void getJavaBinaryFiles(@Nonnull File file, @Nonnull List<File> binaryFiles) throws CannotListDirException {
        if (file.isDirectory()) {
            File[] allFiles = file.listFiles();
            if (allFiles == null) {
                throw new CannotListDirException(new DirectoryLocation(file));
            }
            for (File aFile : allFiles) {
                FileUtils.getJavaBinaryFiles(aFile, binaryFiles);
            }
        } else if (FileUtils.isJavaBinaryFile(file)) {
            binaryFiles.add(file.getAbsoluteFile());
        }
    }

    public static boolean isJavaBinaryFile(@Nonnull File file) {
        return FileUtils.isJavaBinaryFile(file.getName());
    }

    public static boolean isJavaBinaryFile(@Nonnull String fileName) {
        return fileName.endsWith(JAVA_BINARY_FILE_EXTENSION);
    }

    public static boolean isJarFile(@Nonnull File file) {
        return file.getName().endsWith(JAR_FILE_EXTENSION);
    }
}

