/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.item;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Item;
import com.android.sched.item.ItemNotRegisteredError;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedConcreteItem;
import com.android.sched.item.ManagedItem;
import com.android.sched.reflections.ItemManager;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.sched.ManagedDataListener;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractItemManager {
    @Nonnull
    private final ManagedDataListener listener = ManagedDataListenerFactory.getManagedDataListener();
    @Nonnull
    protected Map<Class<? extends Item>, ManagedItem> map = new ConcurrentHashMap<Class<? extends Item>, ManagedItem>();
    @Nonnegative
    private int currentNumIntegers = 0;
    @Nonnegative
    private int currentNumBits = 0;
    @Nonnegative
    private int itemsCount = 0;

    @Nonnull
    public static AbstractItemManager createItemManager(@Nonnull ReflectionManager reflectionManager, @Nonnull Class<? extends Item> type) {
        return new ItemManager(reflectionManager, type);
    }

    protected AbstractItemManager() {
        this.listener.notifyNewItemManager(this);
    }

    @Nonnegative
    public synchronized int getItemsCount() {
        return this.itemsCount;
    }

    @Nonnull
    public abstract Class<? extends Item> getType();

    @Nonnegative
    public synchronized int getIntegersCount() {
        return this.currentNumIntegers + 1;
    }

    @Nonnull
    ManagedItem getManagedItem(@Nonnull Class<? extends Item> cls) {
        ManagedItem item = this.map.get(cls);
        if (item == null) {
            throw new ItemNotRegisteredError(cls);
        }
        return item;
    }

    @Nonnull
    ManagedItem getManagedItem(@Nonnegative int posInteger, @Nonnegative int posBit) {
        for (ManagedItem managedItem : this.map.values()) {
            ManagedConcreteItem concreteItem;
            if (!(managedItem instanceof ManagedConcreteItem) || (concreteItem = (ManagedConcreteItem)managedItem).getPosBit() != posBit || concreteItem.getPosInteger() != posInteger) continue;
            return concreteItem;
        }
        throw new NoSuchElementException("No such item with id <" + posInteger + ", " + posBit + "> for type " + this.getType().getCanonicalName());
    }

    @Nonnull
    protected Collection<ManagedItem> getManagedItems() {
        return this.map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ManagedItem registerItem(@Nonnull Class<? extends Item> item) {
        ManagedItem mi;
        if (Items.getComposedOf(item).length == 0 && !Modifier.isAbstract(item.getModifiers())) {
            int posNumBits;
            int posNumIntegers;
            AbstractItemManager abstractItemManager = this;
            synchronized (abstractItemManager) {
                ++this.itemsCount;
                posNumIntegers = this.currentNumIntegers++;
                posNumBits = this.currentNumBits++;
                if (this.currentNumBits == 64) {
                    this.currentNumBits = 0;
                }
            }
            mi = new ManagedConcreteItem(item, this, posNumIntegers, posNumBits);
        } else {
            mi = new ManagedItem(item, this);
        }
        this.map.put(item, mi);
        return mi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected void registerManagedItem(@Nonnull ManagedItem mi) {
        if (mi instanceof ManagedConcreteItem) {
            AbstractItemManager abstractItemManager = this;
            synchronized (abstractItemManager) {
                ++this.itemsCount;
                int posNumIntegers = this.currentNumIntegers++;
                int posNumBits = this.currentNumBits++;
                if (this.currentNumBits == 64) {
                    this.currentNumBits = 0;
                }
                ((ManagedConcreteItem)mi).setPosition(posNumIntegers, posNumBits);
            }
        }
        this.map.put(mi.getItem(), mi);
    }
}

