/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.item;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Description;
import com.android.sched.item.Item;
import com.android.sched.item.ItemNotConformException;
import com.android.sched.item.Items;
import com.android.sched.util.HasDescription;

public class ManagedItem
implements HasDescription {
    @CheckForNull
    protected long[] bitmap;
    @Nonnull
    private final AbstractItemManager manager;
    @Nonnull
    private final String name;
    @Nonnull
    private final String description;
    @Nonnull
    private final Class<? extends Item> item;

    protected ManagedItem(@Nonnull Class<? extends Item> item, @Nonnull AbstractItemManager manager) {
        this.manager = manager;
        this.item = item;
        this.name = Items.getName(item);
        String description = Items.getDescription(item);
        if (description == null) {
            throw new ItemNotConformException("Item '" + item.getCanonicalName() + "' must have a @" + Description.class.getSimpleName());
        }
        this.description = description;
    }

    @Nonnull
    public Class<? extends Item> getItem() {
        return this.item;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    long[] getBitmap() {
        assert (this.bitmap != null);
        return this.bitmap;
    }

    protected void ensureBitmap() {
        if (this.bitmap == null) {
            this.bitmap = new long[this.manager.getIntegersCount()];
        }
    }

    public void addComposedOf(@Nonnull ManagedItem item) {
        this.ensureBitmap();
        assert (this.bitmap != null);
        item.addComposedOf();
        long[] bitmap = item.getBitmap();
        for (int idx = 0; idx < bitmap.length; ++idx) {
            int n = idx;
            this.bitmap[n] = this.bitmap[n] | bitmap[idx];
        }
    }

    public void addComposedOf() {
        this.ensureBitmap();
        for (Class<? extends Item> i : Items.getComposedOf(this.getItem())) {
            ManagedItem mi = this.manager.getManagedItem(i);
            mi.addComposedOf();
            long[] bitmap = mi.getBitmap();
            assert (this.bitmap != null);
            for (int idx = 0; idx < bitmap.length; ++idx) {
                int n = idx;
                this.bitmap[n] = this.bitmap[n] | bitmap[idx];
            }
        }
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Item '");
        sb.append(this.getName());
        sb.append('\'');
        return new String(sb);
    }

    public final int hashCode() {
        return this.item.hashCode() ^ this.manager.hashCode();
    }

    public final boolean equals(@CheckForNull Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ManagedItem)) {
            return false;
        }
        ManagedItem other = (ManagedItem)obj;
        return this.item.equals(other.item) && this.manager.equals(other.manager);
    }
}

