/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.reflections;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.build.SchedDiscover;
import com.android.sched.reflections.CommonReflectionManager;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class AnnotationProcessorReflectionManager
extends CommonReflectionManager
implements ReflectionManager {
    @Nonnull
    private static final SchedDiscover thisClassLoaderData = AnnotationProcessorReflectionManager.getSchedDiscovery(AnnotationProcessorReflectionManager.class.getClassLoader());
    @Nonnull
    private final SchedDiscover data;
    @Nonnull
    private final ClassLoader classLoader;
    @Nonnull
    private final Location location;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static SchedDiscover getSchedDiscovery(@Nonnull ClassLoader classLoader) {
        try {
            SchedDiscover data = new SchedDiscover();
            Enumeration<URL> enumeration = classLoader.getResources(data.getResourceName());
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    data.readResource(reader);
                }
            }
            return data;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public AnnotationProcessorReflectionManager() {
        this(NoLocation.getInstance());
    }

    public AnnotationProcessorReflectionManager(@Nonnull Location location) {
        this(AnnotationProcessorReflectionManager.class.getClassLoader(), location);
    }

    public AnnotationProcessorReflectionManager(@Nonnull ClassLoader classLoader) {
        this(classLoader, NoLocation.getInstance());
    }

    public AnnotationProcessorReflectionManager(@Nonnull ClassLoader classLoader, @Nonnull Location location) {
        this.classLoader = classLoader;
        this.data = classLoader.equals(AnnotationProcessorReflectionManager.class.getClassLoader()) ? thisClassLoaderData : AnnotationProcessorReflectionManager.getSchedDiscovery(classLoader);
        this.location = location;
    }

    @Override
    @Nonnull
    public <T> Set<Class<? extends T>> getSubTypesOf(@Nonnull Class<T> cls) {
        assert (!cls.isAssignableFrom(Annotation.class));
        return this.get(cls);
    }

    @Override
    @Nonnull
    public <T> Set<ReflectionManager.ClassWithLocation<? extends T>> getSubTypesOfWithLocation(@Nonnull Class<T> cls) {
        assert (!cls.isAssignableFrom(Annotation.class));
        return this.getWithLocation(cls);
    }

    @Override
    @Nonnull
    public <T extends Annotation> Set<Class<?>> getAnnotatedBy(@Nonnull Class<T> cls) {
        return this.get(cls);
    }

    @Override
    @Nonnull
    public <T extends Annotation> Set<ReflectionManager.ClassWithLocation<?>> getAnnotatedByWithLocation(@Nonnull Class<T> cls) {
        return this.getWithLocation(cls);
    }

    @Nonnull
    private Set<Class<?>> get(@Nonnull Class<?> cls) {
        HashSet set = new HashSet();
        for (SchedDiscover.SchedData element : this.data.get(cls.getCanonicalName())) {
            try {
                set.add(Class.forName(element.getName(), false, this.classLoader));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        return set;
    }

    @Nonnull
    private Set<ReflectionManager.ClassWithLocation<?>> getWithLocation(@Nonnull Class<?> cls) {
        HashSet set = new HashSet();
        for (Class<?> c : this.get(cls)) {
            set.add(new ReflectionManager.ClassWithLocation(c, this.location));
        }
        return set;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.location;
    }
}

