/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class AdapterSet
implements Iterable<ManagedVisitor> {
    @Nonnull
    private final Set<ManagedVisitor> adapters = new TreeSet<ManagedSchedulable>(new SchedulableComparator());
    @Nonnull
    private final Map<Pair<Class<? extends Component>, Class<? extends Component>>, List<ManagedVisitor>> cache = new ConcurrentHashMap<Pair<Class<? extends Component>, Class<? extends Component>>, List<ManagedVisitor>>();

    AdapterSet() {
    }

    AdapterSet(@Nonnull AdapterSet initial) {
        this.adapters.addAll(initial.adapters);
    }

    void addAll(@Nonnull AdapterSet set) {
        for (ManagedVisitor ia : set.adapters) {
            this.add(ia);
        }
    }

    protected void add(@Nonnull ManagedVisitor sched) {
        this.adapters.add(sched);
    }

    @Nonnegative
    int getSize() {
        return this.adapters.size();
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (ManagedVisitor sched : this.adapters) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(sched.getName());
        }
        sb.append(']');
        return new String(sb);
    }

    @Override
    @Nonnull
    public Iterator<ManagedVisitor> iterator() {
        return this.adapters.iterator();
    }

    @Nonnull
    public List<ManagedVisitor> getAdapter(@Nonnull Class<? extends Component> current, @Nonnull Class<? extends Component> after) {
        Pair<Class<? extends Component>, Class<? extends Component>> key = new Pair<Class<? extends Component>, Class<? extends Component>>(current, after);
        List<ManagedVisitor> list = this.cache.get(key);
        if (list == null) {
            Stack<ManagedVisitor> stack = new Stack<ManagedVisitor>();
            this.getAdapter(stack, current, after);
            list = new ArrayList<ManagedVisitor>(stack);
            this.cache.put(key, list);
        }
        return list;
    }

    private boolean getAdapter(@Nonnull Stack<ManagedVisitor> stack, @Nonnull Class<? extends Component> current, @Nonnull Class<? extends Component> after) {
        if (current == after) {
            return true;
        }
        for (ManagedVisitor adapter : this.adapters) {
            if (adapter.getRunOn() != current || adapter.getRunOnAfter() != after) continue;
            stack.push(adapter);
            return true;
        }
        for (ManagedVisitor adapter : this.adapters) {
            if (adapter.getRunOn() != current) continue;
            stack.push(adapter);
            if (this.getAdapter(stack, adapter.getRunOnAfter(), after)) {
                return true;
            }
            stack.pop();
        }
        return false;
    }

    public boolean containsAdapters(@Nonnull Class<? extends Component> current, @Nonnull Class<? extends Component> after) {
        if (current == after) {
            return true;
        }
        return !this.getAdapter(current, after).isEmpty();
    }

    private static class Pair<T, S> {
        @Nonnull
        private final T first;
        @Nonnull
        private final S second;

        public Pair(@Nonnull T first, @Nonnull S second) {
            this.first = first;
            this.second = second;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)obj;
            return this.first.equals(pair.first) && this.second.equals(pair.second);
        }

        public int hashCode() {
            return this.first.hashCode() ^ this.second.hashCode();
        }
    }

    private static class SchedulableComparator
    implements Comparator<ManagedSchedulable>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SchedulableComparator() {
        }

        @Override
        public int compare(@CheckForNull ManagedSchedulable o1, @CheckForNull ManagedSchedulable o2) {
            assert (o1 != null);
            assert (o2 != null);
            return o1.getName().compareTo(o2.getName());
        }
    }
}

