/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.google.common.base.CaseFormat;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.PlanAmender;
import com.android.sched.scheduler.PlanConstructor;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.genetic.stats.RunnerPercent;
import com.android.sched.scheduler.genetic.stats.RunnerPercentImpl;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.SchedEventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.StatisticId;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvenSimplerPlanAmender<T extends Component>
implements PlanAmender<T> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @CheckForNull
    private static Map<ManagedRunnable, StatisticId<Percent>> runnerSatisfaction;
    @CheckForNull
    private static Map<ManagedRunnable, StatisticId<Counter>> runnerSuperfluous;

    @Override
    public boolean amendPlan(@Nonnull Request request, @Nonnull Class<T> on, @Nonnull List<ManagedRunnable> runners, @Nonnull PlanConstructor<T> ctor) {
        try (Event event = this.tracer.open(SchedEventType.AMENDER);){
            LinkedList<ManagedRunnable> next = new LinkedList<ManagedRunnable>(runners);
            for (ManagedRunnable runner : runners) {
                ProductionSet productions = runner.getProductions();
                if (!productions.isEmpty() && !request.getTargetProductions().containsAll(productions)) {
                    productions.removeAll(request.getTargetProductions());
                    logger.log(Level.FINE, "Runner ''{0}'' not selected because produces {1} that is not allowed", new Object[]{runner.getName(), productions});
                    next.remove(runner);
                    continue;
                }
                FeatureSet features = runner.getSupportedFeatures();
                if (!features.isEmpty() && !request.getFeatures().containsAll(features)) {
                    features.removeAll(request.getFeatures());
                    logger.log(Level.FINE, "Runner ''{0}'' not selected because supports {1} that is not needed", new Object[]{runner.getName(), features});
                    next.remove(runner);
                    continue;
                }
                if (!productions.isEmpty() || !features.isEmpty()) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    if (features.isEmpty()) {
                        logger.log(Level.FINE, "Runner ''{0}'' is selected because produces {1}", new Object[]{runner.getName(), productions});
                        continue;
                    }
                    if (productions.isEmpty()) {
                        logger.log(Level.FINE, "Runner ''{0}'' is selected because supports {1}", new Object[]{runner.getName(), features});
                        continue;
                    }
                    logger.log(Level.FINE, "Runner ''{0}'' is selected because supports {1} and produces {2}", new Object[]{runner.getName(), features, productions});
                    continue;
                }
                logger.log(Level.FINE, "Runner ''{0}'' is selected", runner.getName());
            }
            boolean bl = this.amendPlan(request, on, next, ctor, 0);
            return bl;
        }
    }

    private boolean amendPlan(@Nonnull Request request, @Nonnull Class<T> on, @Nonnull List<ManagedRunnable> runners, @Nonnull PlanConstructor<T> ctor, int index) {
        if (runners.size() > 0) {
            LinkedList<ManagedRunnable> next = new LinkedList<ManagedRunnable>(runners);
            ManagedRunnable runner = runners.get(0);
            next.remove(0);
            if (ctor.isProductionValid(runner)) {
                for (int idx = index; idx < ctor.getSize() + 1; ++idx) {
                    if (ctor.isConstraintValid(idx, runner)) {
                        if (this.tracer.isTracing()) {
                            this.tracer.getStatistic(this.getRunnerSatisfaction(runner)).addTrue();
                        }
                        logger.log(Level.FINER, "Considering inserting runner ''{0}'' @{1}", new Object[]{runner.getName(), idx});
                        ctor.insert(idx, runner);
                        if (this.amendPlan(request, on, next, ctor, idx + 1)) {
                            return true;
                        }
                        ctor.remove(idx);
                        if (idx >= ctor.getSize()) continue;
                        boolean valid = ctor.isConstraintValid(idx);
                        if (this.tracer.isTracing()) {
                            this.tracer.getStatistic(this.getRunnerSatisfaction(ctor.getRunnerAt(idx))).add(valid);
                        }
                        if (valid) continue;
                        logger.log(Level.FINEST, "Aborting because ''{0}'' @{1} is not valid anymore", new Object[]{ctor.getRunnerAt(idx).getName(), idx});
                        return false;
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.getStatistic(this.getRunnerSatisfaction(runner)).addFalse();
                    }
                    logger.log(Level.FINEST, "Rejecting inserting runner ''{0}'' @{1}", new Object[]{runner.getName(), idx});
                }
                return false;
            }
            if (this.tracer.isTracing()) {
                this.tracer.getStatistic(this.getRunnerSuperfluous(runner)).incValue();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Rejecting runner ''{0}'' because produce superfluous {1}", new Object[]{runner.getName(), ctor.getSuperfluousProductions(runner)});
            }
            return this.amendPlan(request, on, next, ctor, index);
        }
        for (int idx = index; idx < ctor.getSize(); ++idx) {
            boolean valid = ctor.isConstraintValid(idx);
            if (this.tracer.isTracing()) {
                this.tracer.getStatistic(this.getRunnerSatisfaction(ctor.getRunnerAt(idx))).add(valid);
            }
            if (valid) continue;
            logger.log(Level.FINEST, "Aborting because ''{0}'' @{1} is not valid anymore", new Object[]{ctor.getRunnerAt(idx).getName(), idx});
            return false;
        }
        return true;
    }

    @Nonnull
    private StatisticId<Percent> getRunnerSatisfaction(@Nonnull ManagedRunnable runner) {
        if (runnerSatisfaction == null) {
            runnerSatisfaction = new HashMap<ManagedRunnable, StatisticId<Percent>>();
        }
        assert (runnerSatisfaction != null);
        StatisticId<Percent> id = runnerSatisfaction.get(runner);
        if (id == null) {
            String name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, runner.getName());
            id = new StatisticId<RunnerPercent>("sched.amender.even-simpler." + name + ".constraint.satisfied", "Number of times '" + name + "' has all its constraints satisfied", RunnerPercentImpl.class, RunnerPercent.class);
            runnerSatisfaction.put(runner, id);
        }
        return id;
    }

    @Nonnull
    private StatisticId<Counter> getRunnerSuperfluous(@Nonnull ManagedRunnable runner) {
        if (runnerSuperfluous == null) {
            runnerSuperfluous = new HashMap<ManagedRunnable, StatisticId<Counter>>();
        }
        assert (runnerSuperfluous != null);
        StatisticId<Counter> id = runnerSuperfluous.get(runner);
        if (id == null) {
            String name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, runner.getName());
            id = new StatisticId<Counter>("sched.amender.even-simpler." + name + ".production.superfluous", "Number of times '" + name + "' has produced productions already produced", CounterImpl.class, Counter.class);
            runnerSuperfluous.put(runner, id);
        }
        return id;
    }
}

