/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.google.common.base.Function;
import com.android.jill.google.common.collect.Iterators;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.item.Items;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.IllegalRequestException;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.PlanBuilder;
import com.android.sched.scheduler.PlanCandidate;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.SubPlanBuilder;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.SchedEventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlanConstructor<T extends Component>
implements PlanCandidate<T> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final List<Decorated> plan;
    @Nonnegative
    private int currentTagValidityIdx = 0;
    @Nonnegative
    private int constraintTagValidityIdx = Integer.MAX_VALUE;
    @Nonnull
    private final ProductionSet missingProductions;
    @Nonnull
    private final FeatureSet features;
    @Nonnull
    private final Request request;
    @Nonnull
    private final Class<T> rootRunOn;

    public PlanConstructor(@Nonnull Request request, @Nonnull Class<T> rootRunOn, @Nonnull PlanBuilder<T> builder) {
        this(request, rootRunOn, builder.getRunners());
    }

    public PlanConstructor(@Nonnull PlanConstructor<T> analyzer, @Nonnull List<ManagedRunnable> plan) {
        this(analyzer.request, analyzer.rootRunOn, plan);
    }

    PlanConstructor(@Nonnull Request request, @Nonnull Class<T> rootRunOn, @Nonnull List<ManagedRunnable> plan) {
        try (Event event = this.tracer.open(SchedEventType.ANALYZER);){
            this.request = request;
            this.rootRunOn = rootRunOn;
            this.features = request.getFeatures();
            this.missingProductions = request.getTargetProductions();
            this.plan = new LinkedList<Decorated>();
            this.plan.add(new Decorated(request.getInitialTags()));
            for (ManagedRunnable runner : plan) {
                this.plan.add(new DecoratedRunner(runner));
                this.missingProductions.removeAll(runner.getProductions());
            }
            this.plan.add(new Decorated(request.getTargetIncludeTags(), request.getTargetExcludeTags()));
        }
    }

    private void ensureTagsAtIndex(@Nonnegative int atIdx) {
        assert (atIdx >= 0);
        assert (atIdx < this.plan.size());
        if (atIdx > this.currentTagValidityIdx) {
            for (int idx = this.currentTagValidityIdx + 1; idx <= atIdx; ++idx) {
                ((DecoratedRunner)this.plan.get(idx)).updateBeforeTags(this.plan.get(idx - 1).getAfterTags());
            }
            this.currentTagValidityIdx = atIdx;
        }
    }

    private void ensureConstraintsAtIndex(@Nonnegative int atIdx) {
        assert (atIdx >= 0);
        assert (atIdx < this.plan.size() - 1);
        if (atIdx < this.constraintTagValidityIdx) {
            for (int idx = Math.min(this.constraintTagValidityIdx - 1, this.plan.size() - 2); idx >= atIdx; --idx) {
                this.plan.get(idx).updateNeedToAdd(this.plan.get(idx + 1).getNeedToAdd());
                this.plan.get(idx).updateNeedToRemove(this.plan.get(idx + 1).getNeedToRemove());
            }
            this.constraintTagValidityIdx = atIdx;
        }
    }

    @Override
    public boolean isValid() {
        this.ensureConstraintsAtIndex(0);
        return this.request.getInitialTags().containsAll(this.plan.get(0).getNeedToAdd()) && this.request.getInitialTags().containsNone(this.plan.get(0).getNeedToRemove()) && this.missingProductions.isEmpty();
    }

    public boolean isProductionValid(@Nonnull ManagedRunnable runner) {
        return this.missingProductions.containsAll(runner.getProductions());
    }

    public ProductionSet getSuperfluousProductions(@Nonnull ManagedRunnable runner) {
        return (ProductionSet)runner.getProductions().clone().removeAll(this.missingProductions);
    }

    public boolean isConstraintValid(@Nonnegative int index, @Nonnull ManagedRunnable runner) {
        ++index;
        this.ensureTagsAtIndex(--index);
        return runner.isCompatible(this.features, this.plan.get(index).getAfterTags());
    }

    public boolean isConstraintValid(@Nonnegative int index) {
        ++index;
        this.ensureTagsAtIndex(--index);
        return ((DecoratedRunner)this.plan.get(index + 1)).getRunner().isCompatible(this.features, this.plan.get(index).getAfterTags());
    }

    public ManagedRunnable getRunnerAt(@Nonnegative int index) {
        return ((DecoratedRunner)this.plan.get(++index)).getRunner();
    }

    public void insert(@Nonnegative int index, @Nonnull ManagedRunnable runner) {
        assert (this.isConstraintValid(index, runner));
        this.plan.add(++index, new DecoratedRunner(runner));
        this.currentTagValidityIdx = Math.min(index - 1, this.currentTagValidityIdx);
        this.constraintTagValidityIdx = Math.max(index + 1, this.constraintTagValidityIdx);
        this.missingProductions.removeAll(runner.getProductions());
    }

    public void remove(@Nonnegative int index) {
        DecoratedRunner dr = (DecoratedRunner)this.plan.remove(++index);
        this.currentTagValidityIdx = Math.min(index - 1, this.currentTagValidityIdx);
        this.constraintTagValidityIdx = Math.max(index, this.constraintTagValidityIdx);
        this.missingProductions.addAll(dr.getRunner().getProductions());
    }

    @Override
    @Nonnull
    public String getDescription() {
        try {
            return this.getPlanBuilder().getDescription();
        }
        catch (IllegalRequestException e) {
            return "Unknown";
        }
    }

    @Override
    @Nonnull
    public String getDetailedDescription() {
        try {
            return this.getPlanBuilder().getDetailedDescription();
        }
        catch (IllegalRequestException e) {
            return "Unknown";
        }
    }

    @Override
    @Nonnull
    public PlanBuilder<T> getPlanBuilder() throws IllegalRequestException {
        try (Event event = this.tracer.open(SchedEventType.PLANBUILDER);){
            PlanBuilder pb;
            Stack<Class<T>> runOn = new Stack<Class<T>>();
            Stack<SubPlanBuilder> adapters = new Stack<SubPlanBuilder>();
            Stack<Class<? extends Component>> exclusiveAccess = new Stack<Class<? extends Component>>();
            runOn.push(this.rootRunOn);
            adapters.push(this.request.getPlanBuilder(this.rootRunOn));
            exclusiveAccess.push(null);
            Iterator<Decorated> iter = this.plan.iterator();
            Decorated decorated = iter.next();
            Object oldRunner = null;
            while ((decorated = iter.next()) instanceof DecoratedRunner) {
                int i;
                Class currentExclusiveAccess;
                ManagedRunnable runner = ((DecoratedRunner)decorated).getRunner();
                Class<? extends Component> accessComponent = runner.getAccess();
                Class<? extends Component> exclusiveComponent = runner.getExclusiveAccess();
                if (this.request.getVisitors().containsAdapters(exclusiveComponent, accessComponent)) {
                    accessComponent = exclusiveComponent;
                }
                logger.log(Level.FINER, "Runner {0} run on {1}", new Object[]{runner.getName(), Items.getName(runner.getRunOn())});
                logger.log(Level.FINER, "Runner {0} has acces on {1}", new Object[]{runner.getName(), Items.getName(accessComponent)});
                logger.log(Level.FINER, "Runner {0} has exclusive acces on {1}", new Object[]{runner.getName(), Items.getName(exclusiveComponent)});
                if (runOn.peek() != runner.getRunOn() && runOn.contains(runner.getRunOn())) {
                    logger.log(Level.FINE, "Pop adapters before {0} to run on {1}", new Object[]{runner.getName(), Items.getName(runner.getRunOn())});
                    while (runOn.peek() != runner.getRunOn()) {
                        runOn.pop();
                        adapters.pop();
                        exclusiveAccess.pop();
                        logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                    }
                }
                if (runOn.peek() != exclusiveComponent && runOn.contains(exclusiveComponent)) {
                    logger.log(Level.FINE, "Pop adapters before {0} to gain exclusive access to {1}", new Object[]{runner.getName(), Items.getName(exclusiveComponent)});
                    while (runOn.peek() != exclusiveComponent) {
                        runOn.pop();
                        adapters.pop();
                        exclusiveAccess.pop();
                        logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                    }
                }
                if ((currentExclusiveAccess = (Class)exclusiveAccess.peek()) != null && accessComponent != currentExclusiveAccess && this.request.getVisitors().containsAdapters(accessComponent, currentExclusiveAccess)) {
                    logger.log(Level.FINE, "Pop adapters before {0} to gain access to {1} after exclusive access {2}", new Object[]{runner.getName(), Items.getName(accessComponent), Items.getName(currentExclusiveAccess)});
                    while (accessComponent != currentExclusiveAccess && runOn.contains(currentExclusiveAccess)) {
                        runOn.pop();
                        adapters.pop();
                        exclusiveAccess.pop();
                        logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                        if (exclusiveAccess.peek() == null || exclusiveAccess.peek() == currentExclusiveAccess || !this.request.getVisitors().containsAdapters((Class)exclusiveAccess.peek(), currentExclusiveAccess) || exclusiveAccess.peek() == accessComponent || !this.request.getVisitors().containsAdapters(accessComponent, (Class)exclusiveAccess.peek())) continue;
                        currentExclusiveAccess = (Class)exclusiveAccess.peek();
                        logger.log(Level.FINE, "Pop adapters before {0} to gain access to {1} after exclusive access {2}", new Object[]{runner.getName(), Items.getName(accessComponent), Items.getName(currentExclusiveAccess)});
                    }
                }
                if (runner.getRunOn() != runOn.peek()) {
                    while (!runOn.isEmpty()) {
                        if (this.request.getVisitors().containsAdapters((Class)runOn.peek(), runner.getRunOn())) {
                            logger.log(Level.FINE, "Push adapters before {0} to run on {1}", new Object[]{runner.getName(), Items.getName(runner.getRunOn())});
                            for (ManagedVisitor visitor : this.request.getVisitors().getAdapter((Class)runOn.peek(), runner.getRunOn())) {
                                runOn.push(visitor.getRunOnAfter());
                                adapters.push(((SubPlanBuilder)adapters.peek()).appendSubPlan(visitor));
                                exclusiveAccess.push(null);
                                logger.log(Level.FINEST, "Push adapter to be on {0}", Items.getName((Class)runOn.peek()));
                            }
                            break;
                        }
                        logger.log(Level.FINE, "Pop adapters before {0}", runner.getName());
                        runOn.pop();
                        adapters.pop();
                        exclusiveAccess.pop();
                        logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                    }
                }
                ((SubPlanBuilder)adapters.peek()).append(runner);
                exclusiveAccess.pop();
                exclusiveAccess.push(exclusiveComponent);
                if (runOn.peek() != exclusiveComponent && runOn.contains(exclusiveComponent)) {
                    logger.log(Level.FINE, "Pop adapters after {0} to keep exclusive access to {1}", new Object[]{runner.getName(), Items.getName(exclusiveComponent)});
                    while (runOn.peek() != exclusiveComponent) {
                        runOn.pop();
                        adapters.pop();
                        exclusiveAccess.pop();
                        logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                    }
                }
                int level = runOn.size();
                String reason = null;
                block16: for (Class tag : runner.getAddedTags()) {
                    for (i = 0; i < level; ++i) {
                        if (!((Class)runOn.get(i)).isAssignableFrom(tag)) continue;
                        level = i;
                        if (!logger.isLoggable(Level.FINE)) continue block16;
                        reason = "Pop adapters after " + runner.getName() + " to come back to " + Items.getName((Class)runOn.get(level - 1)) + " because it adds " + Items.getName(tag);
                        continue block16;
                    }
                }
                block18: for (Class tag : runner.getRemovedTags()) {
                    for (i = 0; i < level; ++i) {
                        if (!((Class)runOn.get(i)).isAssignableFrom(tag)) continue;
                        level = i;
                        if (!logger.isLoggable(Level.FINE)) continue block18;
                        reason = "Pop adapters after " + runner.getName() + " to come back to " + Items.getName((Class)runOn.get(level - 1)) + " because it removes " + Items.getName(tag);
                        continue block18;
                    }
                }
                if (reason != null) {
                    logger.log(Level.FINE, reason);
                }
                while (adapters.size() > level) {
                    runOn.pop();
                    adapters.pop();
                    exclusiveAccess.pop();
                    logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                }
            }
            if (runOn.peek() != this.rootRunOn) {
                logger.log(Level.FINE, "Pop adapters to end on {0}", Items.getName(this.rootRunOn));
                while (runOn.peek() != this.rootRunOn) {
                    adapters.pop();
                    runOn.pop();
                    exclusiveAccess.pop();
                    logger.log(Level.FINEST, "Pop adapter to be on {0}", Items.getName((Class)runOn.peek()));
                }
            }
            PlanBuilder planBuilder = pb = (PlanBuilder)adapters.pop();
            return planBuilder;
        }
    }

    @Nonnull
    public String toString() {
        this.ensureTagsAtIndex(this.getSize());
        this.ensureConstraintsAtIndex(1);
        return this.plan.toString();
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.plan.size() - 2;
    }

    @Override
    @Nonnull
    public Iterator<ManagedRunnable> iterator() {
        Iterator<Decorated> iter = this.plan.iterator();
        iter.next();
        return Iterators.limit(Iterators.transform(iter, new Function<Decorated, ManagedRunnable>(){

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
            public ManagedRunnable apply(@Nonnull Decorated decorated) {
                return ((DecoratedRunner)decorated).getRunner();
            }
        }), this.getSize());
    }

    private class DecoratedRunner
    extends Decorated {
        @Nonnull
        private final ManagedRunnable runner;

        public DecoratedRunner(ManagedRunnable runner) {
            this.runner = runner;
        }

        @Nonnull
        public ManagedRunnable getRunner() {
            return this.runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateBeforeTags(@Nonnull TagOrMarkerOrComponentSet before) {
            if (this.afterTags == null) {
                this.afterTags = before.clone();
                this.afterTags.clear();
            }
            TagOrMarkerOrComponentSet set = before.clone();
            set.addAll(this.runner.getAddedTags());
            set.removeAll(this.runner.getRemovedTags());
            try {
                boolean bl = this.afterTags.equals(set);
                return bl;
            }
            finally {
                this.afterTags = set;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean updateNeedToAdd(@Nonnull TagOrMarkerOrComponentSet needToAddAfter) {
            if (this.needToAdd == null) {
                this.needToAdd = needToAddAfter.clone();
                this.needToAdd.clear();
            }
            TagOrMarkerOrComponentSet set = needToAddAfter.clone();
            set.removeAll(this.runner.getAddedTags());
            set.addAll(this.runner.getNeededTags(PlanConstructor.this.features));
            try {
                boolean bl = this.needToAdd.equals(set);
                return bl;
            }
            finally {
                this.needToAdd = set;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean updateNeedToRemove(@Nonnull TagOrMarkerOrComponentSet needToRemoveAfter) {
            if (this.needToRemove == null) {
                this.needToRemove = needToRemoveAfter.clone();
                this.needToRemove.clear();
            }
            TagOrMarkerOrComponentSet set = needToRemoveAfter.clone();
            set.removeAll(this.runner.getRemovedTags());
            set.addAll(this.runner.getUnsupportedTags(PlanConstructor.this.features));
            try {
                boolean bl = this.needToRemove.equals(set);
                return bl;
            }
            finally {
                this.needToRemove = set;
            }
        }

        @Override
        @Nonnull
        public String toString() {
            return this.runner.getName() + ", needToAdd: " + this.getNeedToAdd() + ", needToRemove: " + this.getNeedToRemove() + ", afterTags: " + this.getAfterTags();
        }
    }

    private static class Decorated {
        @CheckForNull
        protected TagOrMarkerOrComponentSet afterTags;
        @CheckForNull
        protected TagOrMarkerOrComponentSet needToAdd;
        @CheckForNull
        protected TagOrMarkerOrComponentSet needToRemove;

        protected Decorated() {
        }

        public Decorated(@Nonnull TagOrMarkerOrComponentSet initial) {
            this.afterTags = initial.clone();
        }

        public Decorated(@Nonnull TagOrMarkerOrComponentSet needed, @Nonnull TagOrMarkerOrComponentSet forbidden) {
            this.needToAdd = needed.clone();
            this.needToRemove = forbidden.clone();
        }

        @Nonnull
        public TagOrMarkerOrComponentSet getAfterTags() {
            assert (this.afterTags != null);
            return this.afterTags;
        }

        @Nonnull
        public TagOrMarkerOrComponentSet getNeedToAdd() {
            assert (this.needToAdd != null);
            return this.needToAdd;
        }

        @Nonnull
        public TagOrMarkerOrComponentSet getNeedToRemove() {
            assert (this.needToRemove != null);
            return this.needToRemove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateNeedToAdd(@Nonnull TagOrMarkerOrComponentSet neededAfter) {
            if (this.needToAdd == null) {
                this.needToAdd = neededAfter.clone();
                this.needToAdd.clear();
            }
            TagOrMarkerOrComponentSet set = neededAfter.clone();
            try {
                boolean bl = this.needToAdd.equals(set);
                return bl;
            }
            finally {
                this.needToAdd = set;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateNeedToRemove(@Nonnull TagOrMarkerOrComponentSet forbiddenAfter) {
            if (this.needToRemove == null) {
                this.needToRemove = forbiddenAfter.clone();
                forbiddenAfter.clear();
            }
            TagOrMarkerOrComponentSet set = forbiddenAfter.clone();
            try {
                boolean bl = this.needToRemove.equals(set);
                return bl;
            }
            finally {
                this.needToRemove = set;
            }
        }

        @Nonnull
        public String toString() {
            return (this.afterTags != null ? "<initial>" : "<final>") + ", needToAdd: " + this.getNeedToAdd() + ", needToRemove: " + this.getNeedToRemove() + ", afterTags: " + (this.afterTags != null ? this.getAfterTags() : "<none>");
        }
    }
}

