/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.util.config.ChainedException;

public abstract class ProcessException
extends ChainedException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String name;
    @Nonnull
    private final Object data;
    @Nonnull
    private final Throwable cause;

    public ProcessException(@Nonnull Schedulable schedulable, @CheckForNull ManagedSchedulable managedSchedulable, @Nonnull Object data, @Nonnull Throwable cause) {
        super("");
        this.name = managedSchedulable != null ? managedSchedulable.getName() : "<" + schedulable.getClass().getSimpleName() + ">";
        this.data = data;
        this.cause = cause;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Object getData() {
        return this.data;
    }

    @Override
    @Nonnull
    public Throwable getCause() {
        return this.cause;
    }

    @Nonnull
    protected String getAdditionalCauseMessage() {
        String msg = this.cause.getMessage();
        if (msg != null) {
            return ": " + msg;
        }
        return "";
    }
}

