/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.SchedProperties;
import com.android.sched.item.Component;
import com.android.sched.item.Items;
import com.android.sched.item.onlyfor.Default;
import com.android.sched.item.onlyfor.OnlyForType;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.ProcessorSchedulable;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.SchedulableNotConformException;
import com.android.sched.scheduler.SchedulableSet;
import com.android.sched.scheduler.Scheduler;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.sched.ManagedDataListener;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulableManager {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Class<? extends OnlyForType> onlyFor = ThreadConfig.get(SchedProperties.ONLY_FOR);
    @Nonnull
    private final ManagedDataListener listener = ManagedDataListenerFactory.getManagedDataListener();
    private final boolean failedStop = ThreadConfig.get(SchedProperties.FAILED_STOP);
    @Nonnull
    protected Map<Class<? extends Schedulable>, ManagedSchedulable> schedulableByClass = new HashMap<Class<? extends Schedulable>, ManagedSchedulable>();

    @Nonnull
    public static SchedulableManager getSchedulableManager(@Nonnull Scheduler scheduler, @Nonnull ReflectionManager reflectionManager) {
        return new SchedulableManager(scheduler, reflectionManager);
    }

    public SchedulableManager(@Nonnull Scheduler scheduler, @Nonnull ReflectionManager reflectionManager) {
        for (Class<Schedulable> sched : reflectionManager.getSubTypesOf(Schedulable.class)) {
            Class<? extends OnlyForType> onlyFor = Items.getOnlyForType(sched);
            if (onlyFor == Default.class || onlyFor == this.onlyFor) {
                if (sched.isInterface() || Modifier.isAbstract(sched.getModifiers())) continue;
                try {
                    ManagedSchedulable is = this.register(scheduler, sched);
                    this.listener.notifyNewManagedSchedulable(is);
                    logger.log(Level.INFO, "Register schedulable ''{0}'' ({1})", new Object[]{is.getName(), sched.getCanonicalName()});
                    continue;
                }
                catch (SchedulableNotConformException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    if (!this.failedStop) continue;
                    throw e;
                }
            }
            logger.log(Level.INFO, "Schedulable ''{0}'' ({1}) is ignored because only for {2}", new Object[]{Items.getName(sched), sched.getCanonicalName(), onlyFor.getSimpleName()});
        }
        this.listener.notifyNoMoreManagedSchedulable();
    }

    protected ManagedSchedulable register(@Nonnull Scheduler scheduler, @Nonnull Class<? extends Schedulable> sched) throws SchedulableNotConformException {
        ManagedSchedulable is = null;
        if (ProcessorSchedulable.class.isAssignableFrom(sched)) {
            ManagedRunnable ir = new ManagedRunnable(scheduler, sched);
            is = ir;
        } else if (AdapterSchedulable.class.isAssignableFrom(sched)) {
            ManagedVisitor iv = new ManagedVisitor((Class<? extends AdapterSchedulable<? extends Component, ? extends Component>>)sched);
            is = iv;
        } else {
            throw new AssertionError();
        }
        assert (this.schedulableByClass != null);
        for (ManagedSchedulable elt : this.schedulableByClass.values()) {
            if (!is.getName().equals(elt.getName())) continue;
            throw new SchedulableNotConformException("Schedulable '" + sched.getCanonicalName() + "' and '" + elt.getSchedulable().getCanonicalName() + "' have the same name '" + elt.getName() + "'");
        }
        this.schedulableByClass.put(sched, is);
        return is;
    }

    @CheckForNull
    public ManagedSchedulable getManagedSchedulable(@Nonnull Class<? extends Schedulable> schedulable) {
        return this.schedulableByClass.get(schedulable);
    }

    @Nonnull
    SchedulableSet getAllSchedulable(@Nonnull SchedulableManager manager) {
        SchedulableSet scheds = new SchedulableSet(manager);
        for (ManagedSchedulable sched : this.schedulableByClass.values()) {
            scheds.add(sched);
        }
        return scheds;
    }
}

