/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.DirectFSCodec;
import com.android.sched.util.codec.MessageDigestCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.VFSCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.CaseInsensitiveFS;
import com.android.sched.vfs.VFS;
import java.security.Provider;
import java.util.List;

public class CaseInsensitiveDirectFSCodec
implements VFSCodec {
    @Nonnull
    private final DirectFSCodec codec;
    @Nonnull
    private final MessageDigestCodec messageDigestCodec = new MessageDigestCodec();

    public CaseInsensitiveDirectFSCodec() {
        this.codec = new DirectFSCodec();
    }

    public CaseInsensitiveDirectFSCodec(@Nonnull FileOrDirectory.Existence mustExist) {
        this.codec = new DirectFSCodec(mustExist);
    }

    @Override
    @Nonnull
    public VFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public VFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            Provider.Service service = (Provider.Service)this.messageDigestCodec.checkString(context, "SHA");
            return new CaseInsensitiveFS(this.codec.checkString(context, string), 1, 2, new MessageDigestFactory(service), false);
        }
        catch (BadVFSFormatException e) {
            throw new ParsingException(e);
        }
    }

    @Override
    @Nonnull
    public String getUsage() {
        return this.codec.getUsage();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.codec.getVariableName();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.codec.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull VFS data) {
        return this.codec.formatValue(data);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull VFS data) {
        this.codec.checkValue(context, data);
    }

    @Nonnull
    public CaseInsensitiveDirectFSCodec setInfoString(@CheckForNull String infoString) {
        this.codec.setInfoString(infoString);
        return this;
    }
}

