/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class CodecContext {
    private boolean debug = false;
    @CheckForNull
    private RunnableHooks hooks;
    @Nonnull
    private Charset defaultCharset = Charset.defaultCharset();
    @Nonnull
    private InputStream standardInput = System.in;
    @Nonnull
    private Charset standardInputCharset = Charset.defaultCharset();
    @Nonnull
    private PrintStream standardOutput = System.out;
    @Nonnull
    private Charset standardOutputCharset = Charset.defaultCharset();
    @Nonnull
    private PrintStream standardError = System.err;
    @Nonnull
    private Charset standardErrorCharset = Charset.defaultCharset();
    @CheckForNull
    private Directory workingDirectory;

    @Nonnull
    public CodecContext setDebug() {
        this.debug = true;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @CheckForNull
    public RunnableHooks getRunnableHooks() {
        return this.hooks;
    }

    @Nonnull
    public CodecContext setHooks(@Nonnull RunnableHooks hooks) {
        this.hooks = hooks;
        return this;
    }

    @Nonnull
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(@Nonnull Charset charset) {
        this.defaultCharset = charset;
    }

    @Nonnull
    public InputStream getStandardInput() {
        return this.standardInput;
    }

    public void setStandardInput(@Nonnull InputStream standardInput) {
        this.standardInput = standardInput;
    }

    @Nonnull
    public Charset getStandardInputCharset() {
        return this.standardInputCharset;
    }

    public void setStandardInputCharset(@Nonnull Charset charset) {
        this.standardInputCharset = charset;
    }

    @Nonnull
    public PrintStream getStandardOutput() {
        return this.standardOutput;
    }

    public void setStandardOutput(@Nonnull PrintStream standardOutput) {
        this.standardOutput = standardOutput;
    }

    @Nonnull
    public Charset getStandardOutputCharset() {
        return this.standardOutputCharset;
    }

    public void setStandardOutputCharset(@Nonnull Charset charset) {
        this.standardOutputCharset = charset;
    }

    @Nonnull
    public PrintStream getStandardError() {
        return this.standardError;
    }

    public void setStandardError(@Nonnull PrintStream standardError) {
        this.standardError = standardError;
    }

    @Nonnull
    public Charset getStandardErrorCharset() {
        return this.standardErrorCharset;
    }

    public void setStandardErrorCharset(@Nonnull Charset charset) {
        this.standardErrorCharset = charset;
    }

    @CheckForNull
    public Directory getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(@Nonnull File workingDirectory) throws NotDirectoryException, WrongPermissionException, NoSuchFileException {
        try {
            this.workingDirectory = new Directory(workingDirectory.getPath(), null, FileOrDirectory.Existence.MUST_EXIST, 4, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
    }
}

