/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.google.common.base.Joiner;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.Selector;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.DefaultFactory;
import com.android.sched.util.config.ReflectDefaultCtorFactory;

public class DefaultFactorySelector<T>
extends Selector<T>
implements StringCodec<DefaultFactory<T>> {
    private boolean bypassAccessibility = false;

    public DefaultFactorySelector(@Nonnull Class<T> type) {
        super(type);
    }

    @Nonnull
    public DefaultFactorySelector<T> bypassAccessibility() {
        this.bypassAccessibility = true;
        return this;
    }

    @Override
    @Nonnull
    public DefaultFactory<T> checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        return new ReflectDefaultCtorFactory(this.getClass(string), !this.bypassAccessibility);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull DefaultFactory<T> factory) throws CheckingException {
        if (!this.checkClass(factory.getInstantiatedClass())) {
            throw new CheckingException("The value must be a DefaultFactory<{" + Joiner.on(',').join(this.getClasses()) + "}> but is a DefaultFactory<" + factory.getInstantiatedClass().getCanonicalName() + ">");
        }
    }

    @Override
    @Nonnull
    public DefaultFactory<T> parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull DefaultFactory<T> factory) {
        return this.getName(factory.getInstantiatedClass());
    }
}

