/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.VFSCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.CachedDirectFS;
import com.android.sched.vfs.DirectFS;
import com.android.sched.vfs.VFS;

public class DirectFSCodec
extends FileOrDirCodec<VFS>
implements VFSCodec {
    @CheckForNull
    private String infoString;
    private boolean useCache = true;

    public DirectFSCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 3);
        assert ((this.permissions & 4) == 0);
    }

    public DirectFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence, 3);
    }

    @Nonnull
    public DirectFSCodec withoutCache() {
        this.useCache = false;
        return this;
    }

    @Nonnull
    public DirectFSCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public DirectFSCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull VFS dir) {
    }

    @Override
    @Nonnull
    public VFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull VFS directory) {
        return directory.getPath();
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "dir";
    }

    @Override
    @Nonnull
    public VFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            BaseVFS vfs;
            Directory dir = new Directory(context.getWorkingDirectory(), string, context.getRunnableHooks(), this.existence, this.permissions, this.change);
            if (this.useCache) {
                CachedDirectFS cdFS = new CachedDirectFS(dir, this.permissions);
                cdFS.setInfoString(this.infoString);
                vfs = cdFS;
            } else {
                DirectFS dFS = new DirectFS(dir, this.permissions);
                dFS.setInfoString(this.infoString);
                vfs = dFS;
            }
            return vfs;
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new ParsingException(e);
        }
    }

    @Nonnull
    public DirectFSCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

