/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.DirectFSCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.VFS;
import java.util.List;
import java.util.logging.Logger;

public class DirectoryInputVFSCodec
implements StringCodec<InputVFS> {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    private String infoString;
    @Nonnull
    private final DirectFSCodec directFSCodec = new DirectFSCodec();

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to an input directory (" + this.directFSCodec.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.directFSCodec.getVariableName();
    }

    @Nonnull
    public DirectoryInputVFSCodec withoutCache() {
        this.directFSCodec.withoutCache();
        return this;
    }

    @Override
    @Nonnull
    public InputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        VFS vfs = this.directFSCodec.checkString(context, string);
        return new GenericInputVFS(vfs);
    }

    @Override
    @Nonnull
    public InputVFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Nonnull
    public DirectoryInputVFSCodec setInfoString(@Nonnull String infoString) {
        this.directFSCodec.setInfoString(infoString);
        return this;
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.directFSCodec.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputVFS data) {
        return this.directFSCodec.formatValue(data.getVFS());
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputVFS data) {
        this.directFSCodec.checkValue(context, data.getVFS());
    }
}

