/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.Collections;
import java.util.List;

public class DoubleCodec
implements StringCodec<Double> {
    private double min = -1.7976931348623157E308;
    private double max = Double.MAX_VALUE;

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a real number belonging to [" + this.min + " .. " + this.max + "]";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "number";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Double checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            Double d = Double.valueOf(string);
            try {
                this.checkValue(context, d);
            }
            catch (CheckingException e) {
                throw new ParsingException(e);
            }
            return d;
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Double d) throws CheckingException {
        double v = d;
        if (v < this.min || v > this.max) {
            throw new CheckingException("The value must be " + this.getUsage() + " but is " + d);
        }
    }

    @Override
    @Nonnull
    public Double parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Double d) {
        return d.toString();
    }
}

