/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.Formatter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DurationFormatter
implements Formatter<Long> {
    @Nonnull
    private static final TimeUnit[] UNIT_TIME = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    @Nonnull
    private static final String[] UNIT_PREFIX = new String[]{"d", "h", "min", "s", "ms", "\u00b5s", "ns"};
    @Nonnull
    private TimeUnit ref = TimeUnit.NANOSECONDS;
    @Nonnull
    private NumberFormat formatter;

    public DurationFormatter() {
        this.formatter = NumberFormat.getIntegerInstance();
        this.formatter.setMaximumFractionDigits(4);
    }

    public DurationFormatter(@Nonnull Locale locale) {
        this.formatter = NumberFormat.getIntegerInstance(locale);
        this.formatter.setMaximumFractionDigits(4);
    }

    @Nonnull
    public NumberFormat getNumberFormatter() {
        return this.formatter;
    }

    @Nonnull
    public DurationFormatter setNumberFormatter(@Nonnull DecimalFormat formatter) {
        this.formatter = formatter;
        return this;
    }

    @Nonnull
    public DurationFormatter setInputUnit(@Nonnull TimeUnit unit) {
        this.ref = unit;
        return this;
    }

    @Nonnull
    public DurationFormatter setPrecise() {
        this.formatter.setMaximumFractionDigits(340);
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Long data) {
        long ns = data;
        if (ns == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (ns < 0L) {
            sb.append('-');
            ns = -ns;
        }
        int idx = 0;
        for (TimeUnit unit : UNIT_TIME) {
            double u = (double)ns / (double)this.ref.convert(1L, unit);
            if (u >= 1.0) {
                sb.append(this.formatter.format((Object)u));
                sb.append(' ');
                sb.append(UNIT_PREFIX[idx]);
                break;
            }
            ++idx;
        }
        return sb.toString();
    }
}

