/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CharsetCodec;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.file.FileOrDirectory;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public abstract class FileCodec<T>
extends FileOrDirCodec<T> {
    @Nonnull
    protected static final String STANDARD_IO_NAME = "-";
    @Nonnull
    protected static final String STANDARD_ERROR_NAME = "--";
    protected boolean allowStandardIO = false;
    protected boolean allowStandardError = false;
    @CheckForNull
    protected CharsetCodec charsetCodec = null;
    @CheckForNull
    protected Charset defaultCharset = null;

    protected FileCodec(@Nonnull FileOrDirectory.Existence existence, int permissions) {
        super(existence, permissions);
        assert ((permissions & 1) != 0 || (permissions & 2) != 0);
    }

    @CheckForNull
    protected Charset parseCharset(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        Charset charset = null;
        if (this.charsetCodec != null && string.charAt(string.length() - 1) == ']') {
            int idx = string.lastIndexOf(91);
            if (idx == -1) {
                throw new ParsingException("The value may be ended by '[<charset>]' but is '" + string + "'");
            }
            String encoding = string.substring(idx + 1, string.length() - 1);
            try {
                charset = this.charsetCodec.checkString(context, encoding);
                if (charset == null) {
                    charset = this.charsetCodec.parseString(context, encoding);
                }
            }
            catch (ParsingException e) {
                throw new ParsingException("The value must be " + this.getLongUsage() + " but <charset> is '" + encoding + "'");
            }
        }
        return charset;
    }

    @Nonnull
    protected Charset getCharset(@Nonnull CodecContext context, @CheckForNull Charset localCharset) {
        if (localCharset != null) {
            return localCharset;
        }
        if (this.defaultCharset != null) {
            return this.defaultCharset;
        }
        return context.getDefaultCharset();
    }

    @Override
    @Nonnull
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("a path to a file (");
        sb.append(this.getDetailedUsage());
        sb.append(")");
        if (this.allowStandardIO) {
            FileOrDirCodec.StringBuilderAppender sbSlash = new FileOrDirCodec.StringBuilderAppender("/");
            sbSlash.append(", can be '");
            sbSlash.append(STANDARD_IO_NAME);
            sbSlash.append("' for standard ");
            sbSlash.append((this.permissions & 1) != 0, "input");
            sbSlash.append((this.permissions & 2) != 0, "output");
            sb.append(sbSlash.toString());
        }
        if (this.allowStandardError) {
            sb.append(", can be '");
            sb.append(STANDARD_ERROR_NAME);
            sb.append("' for standard error");
        }
        if (this.charsetCodec != null) {
            sb.append(", can be ended by [<charset>] where <charset> is ");
            sb.append(this.charsetCodec.getUsage());
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "file";
    }

    @Nonnull
    protected String getLongUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("a path to a file");
        if (this.charsetCodec != null) {
            sb.append(", can be ended by [<charset>] where <charset> is ");
            sb.append(this.charsetCodec.getDetailedUsage());
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }
}

