/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputStreamFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.StandardInputLocation;

public class InputStreamCodec
extends FileCodec<InputStreamFile> {
    @Nonnull
    private static final Location STANDARD_INPUT_LOCATION = new StandardInputLocation();

    public InputStreamCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
    }

    @Nonnull
    public InputStreamCodec allowStandardInput() {
        this.allowStandardIO = true;
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputStreamFile stream) {
        if (stream.isStandard()) {
            return "-";
        }
        return stream.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputStreamFile stream) throws CheckingException {
        if (stream.isStandard() && !this.allowStandardIO) {
            throw new CheckingException("Standard input is not allowed");
        }
    }

    @Override
    @Nonnull
    public InputStreamFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public InputStreamFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (string.equals("-")) {
            if (!this.allowStandardIO) {
                throw new ParsingException("Standard input can not be used");
            }
            return new InputStreamFile(context.getStandardInput(), STANDARD_INPUT_LOCATION);
        }
        try {
            return new InputStreamFile(context.getWorkingDirectory(), string);
        }
        catch (NoSuchFileException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }
}

