/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.KeyValueCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import java.util.List;

public class KeywordsCodec
implements StringCodec<String> {
    @Nonnull
    KeyValueCodec<String> parser;

    public KeywordsCodec(@Nonnull String varName, @Nonnull String[] keywords) {
        this(varName, keywords, new String[keywords.length]);
    }

    public KeywordsCodec(@Nonnull String varName, @Nonnull String[] keywords, @Nonnull String[] descriptions) {
        KeyValueCodec.Entry[] entries = new KeyValueCodec.Entry[keywords.length];
        int idx = 0;
        for (String keyword : keywords) {
            entries[idx] = new KeyValueCodec.Entry<String>(keyword, keyword, descriptions[idx]);
            ++idx;
        }
        this.parser = new KeyValueCodec(varName, entries);
    }

    @Nonnull
    public KeywordsCodec ignoreCase() {
        this.parser.ignoreCase();
        return this;
    }

    @Nonnull
    public KeywordsCodec sort() {
        this.parser.sorted();
        return this;
    }

    @Override
    @Nonnull
    public String parseString(@Nonnull CodecContext context, @Nonnull String string) {
        return this.parser.parseString(context, string);
    }

    @Override
    @CheckForNull
    public String checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        return this.parser.checkString(context, string);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull String string) throws CheckingException {
        this.parser.checkValue(context, string);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return this.parser.getUsage();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.parser.getVariableName();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.parser.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull String value) {
        return this.parser.formatValue(value);
    }
}

