/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ListCheckingException;
import com.android.sched.util.codec.ListParsingException;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ChainedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

public class ListCodec<T>
implements StringCodec<List<T>> {
    @Nonnull
    private final StringCodec<T> parser;
    @Nonnegative
    private int min;
    @Nonnegative
    private int max;
    @Nonnull
    private String regexp = Pattern.quote(this.separator);
    @Nonnull
    private String separator = ",";
    private boolean unicity = false;

    public ListCodec(@Nonnull StringCodec<T> parser) {
        this.parser = parser;
        this.min = 1;
        this.max = Integer.MAX_VALUE;
    }

    public ListCodec<T> setSeparator(@Nonnull String separator) {
        this.separator = separator;
        this.regexp = Pattern.quote(separator);
        return this;
    }

    @Nonnull
    public String getSeparator() {
        return this.separator;
    }

    public ListCodec<T> setMin(@Nonnegative int min) {
        assert (min < this.max);
        assert (min >= 0);
        this.min = min;
        return this;
    }

    public ListCodec<T> setMax(@Nonnegative int max) {
        assert (this.min < max);
        assert (max > 0);
        this.max = max;
        return this;
    }

    public ListCodec<T> ensureUnicity() {
        this.unicity = true;
        return this;
    }

    @Override
    @Nonnull
    public List<T> parseString(@Nonnull CodecContext context, @Nonnull String string) {
        if ((string = string.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        String[] values = string.split(this.regexp);
        ArrayList list = new ArrayList(values.length);
        for (String v : values) {
            list.add(this.parser.parseString(context, v.trim()));
        }
        return list;
    }

    @Override
    @CheckForNull
    public List<T> checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        ChainedException.ChainedExceptionBuilder<ParsingException> exceptions = new ChainedException.ChainedExceptionBuilder<ParsingException>();
        String[] values = string.trim().split(this.regexp);
        int size = values.length;
        if (size < this.min) {
            exceptions.appendException(new ParsingException("The minimal number of element in the list must be " + this.min + " but is " + values.length));
        }
        if (size == 1 && values[0].isEmpty()) {
            return Collections.emptyList();
        }
        if (size > this.max) {
            exceptions.appendException(new ParsingException("The maximal number of element in the list must be " + this.max + " but is " + values.length));
        }
        int index = 0;
        ArrayList list = new ArrayList(values.length);
        for (String v : values) {
            try {
                Object element = this.parser.checkString(context, v.trim());
                if (element == null) {
                    if (this.unicity) {
                        element = this.parser.parseString(context, v.trim());
                    } else {
                        list = null;
                    }
                }
                if (list != null) {
                    if (list.contains(element)) {
                        exceptions.appendException(new ListParsingException(index, "'" + v + "' is redundant with element #" + (list.indexOf(element) + 1)));
                    }
                    list.add(element);
                }
            }
            catch (ParsingException e) {
                exceptions.appendException(new ListParsingException(index, (Throwable)e));
            }
            ++index;
        }
        exceptions.throwIfNecessary();
        return list;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull List<T> list) throws CheckingException {
        ChainedException.ChainedExceptionBuilder<CheckingException> exceptions = new ChainedException.ChainedExceptionBuilder<CheckingException>();
        int size = list.size();
        if (size < this.min) {
            exceptions.appendException(new CheckingException("The minimal number of element in the list must be " + this.min + " but is " + size));
        }
        if (size > this.max) {
            exceptions.appendException(new CheckingException("The maximal number of element in the list must be " + this.max + " but is " + size));
        }
        ArrayList<T> uniq = new ArrayList<T>(list.size());
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            T element = iter.next();
            try {
                this.parser.checkValue(context, element);
                if (!this.unicity) continue;
                if (uniq.contains(element)) {
                    exceptions.appendException(new ListCheckingException(index, "'" + this.parser.formatValue(element) + "' is redundant with element #" + list.indexOf(element)));
                }
                uniq.add(element);
            }
            catch (CheckingException e) {
                exceptions.appendException(new ListCheckingException(index, (Throwable)e));
            }
        }
        exceptions.throwIfNecessary();
    }

    @Override
    @Nonnull
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        String var = this.parser.getVariableName();
        if (this.min > 0) {
            sb.append('<').append(var).append("-1").append('>');
            if (this.min > 2) {
                sb.append(this.separator);
                sb.append("<...>");
            }
            if (this.min > 1) {
                sb.append(this.separator);
                sb.append('<').append(var).append('-').append(this.min).append('>');
            }
        }
        if (this.min < this.max) {
            StringBuilder end = new StringBuilder();
            sb.append('[');
            end.append(']');
            if (this.min > 0) {
                sb.append(this.separator);
            }
            sb.append('<').append(var).append('-').append(this.min + 1).append('>');
            if (this.max - this.min > 2) {
                sb.append('[');
                end.append(']');
                sb.append(this.separator);
                sb.append("...");
            }
            if (this.max - this.min > 1) {
                sb.append('[');
                end.append(']');
                sb.append(this.separator);
                if (this.max == Integer.MAX_VALUE) {
                    sb.append('<').append(var).append("-n").append('>');
                } else {
                    sb.append('<').append(var).append('-').append(this.max).append('>');
                }
            }
            sb.append((CharSequence)end);
        }
        sb.append(" where <").append(var).append("-i> is ");
        sb.append(this.parser.getUsage());
        if (this.unicity) {
            sb.append(" and unique");
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "list";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.parser.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull List<T> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T element : list) {
            if (first) {
                first = false;
            } else {
                sb.append(this.separator);
            }
            sb.append(this.parser.formatValue(element));
        }
        return sb.toString();
    }
}

