/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ConvertCodec;
import com.android.sched.util.codec.ListParsingException;
import com.android.sched.util.codec.PairCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ChainedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PairListToMapCodecConverter<T, U>
extends ConvertCodec<List<PairCodec.Pair<T, U>>, Map<T, U>> {
    public PairListToMapCodecConverter(StringCodec<List<PairCodec.Pair<T, U>>> codec) {
        super(codec);
    }

    @Override
    @Nonnull
    protected List<PairCodec.Pair<T, U>> revert(@Nonnull Map<T, U> data) {
        ArrayList<PairCodec.Pair<T, U>> list = new ArrayList<PairCodec.Pair<T, U>>(data.size());
        for (Map.Entry<T, U> entry : data.entrySet()) {
            list.add(new PairCodec.Pair<T, U>(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    @Override
    @Nonnull
    protected Map<T, U> convert(@Nonnull List<PairCodec.Pair<T, U>> list) throws ParsingException {
        ChainedException.ChainedExceptionBuilder<ListParsingException> exceptions = new ChainedException.ChainedExceptionBuilder<ListParsingException>();
        HashMap<T, U> map = new HashMap<T, U>(Math.round((float)list.size() / 0.75f), 0.75f);
        int index = 1;
        for (PairCodec.Pair<T, U> pair : list) {
            if (!map.containsKey(pair.getFirst())) {
                map.put(pair.getFirst(), pair.getSecond());
            } else {
                exceptions.appendException(new ListParsingException(index, "Value for '" + pair.getFirst().toString() + "' is already defined"));
            }
            ++index;
        }
        exceptions.throwIfNecessary();
        return map;
    }
}

